/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt;

import java.util.ArrayList;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.ParameterDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.sts.mgt.dto.CardIssuerDTO;
import org.wso2.carbon.identity.sts.mgt.dto.CardIssuerTokenDTO;
import org.wso2.carbon.registry.core.Registry;

public class STSAdminService {
    public CardIssuerDTO readCardIssuerConfiguration() throws Exception {
        int i;
        CardIssuerTokenDTO token;
        CardIssuerDTO dto = null;
        IdentityPersistenceManager dbAmin = null;
        ParameterDO param = null;
        ArrayList<CardIssuerTokenDTO> supportedTokens = null;
        String[] tokens = null;
        Registry registry = null;
        dbAmin = IdentityPersistenceManager.getPersistanceManager();
        dto = new CardIssuerDTO();
        registry = IdentityTenantUtil.getRegistry();
        supportedTokens = new ArrayList<CardIssuerTokenDTO>();
        param = dbAmin.getParameter(registry, "SupportedTokenTypes");
        if (param == null || param.getValue() == null) {
            this.addParameters(registry);
            param = dbAmin.getParameter(registry, "SupportedTokenTypes");
        }
        if (param != null && param.getValue() != null) {
            tokens = param.getValue().split(",");
            token = null;
            for (i = 0; i < tokens.length; ++i) {
                token = new CardIssuerTokenDTO();
                if (tokens[i].trim().length() <= 0) continue;
                token.setTokenType(this.getTokenType(tokens[i]));
                token.setSupported(true);
                supportedTokens.add(token);
            }
        }
        if ((param = dbAmin.getParameter(registry, "NotSupportedTokenTypes")) != null && param.getValue() != null) {
            tokens = param.getValue().split(",");
            token = null;
            for (i = 0; i < tokens.length; ++i) {
                if (tokens[i].trim().length() <= 0) continue;
                token = new CardIssuerTokenDTO();
                token.setTokenType(this.getTokenType(tokens[i]));
                token.setSupported(false);
                supportedTokens.add(token);
            }
        }
        dto.setSupportedTokenTypes(supportedTokens.toArray(new CardIssuerTokenDTO[supportedTokens.size()]));
        param = dbAmin.getParameter(registry, "CardName");
        if (param != null && param.getValue() != null) {
            dto.setCardName(param.getValue());
        }
        if ((param = dbAmin.getParameter(registry, "ValidPeriod")) != null && param.getValue() != null) {
            dto.setValidPeriodInDays(Integer.parseInt(param.getValue()));
        }
        if ((param = dbAmin.getParameter(registry, "useSymmBinding")) != null && param.getValue() != null) {
            if ("true".equals(param.getValue())) {
                dto.setSymmetricBinding(true);
            } else {
                dto.setSymmetricBinding(false);
            }
        }
        return dto;
    }

    public void updateCardIssueConfiguration(CardIssuerDTO issuer) throws Exception {
        IdentityPersistenceManager dbAmin = null;
        CardIssuerTokenDTO[] supportedTokens = null;
        StringBuilder supportedBuffer = null;
        StringBuilder notSupportedBuffer = null;
        dbAmin = IdentityPersistenceManager.getPersistanceManager();
        supportedTokens = issuer.getSupportedTokenTypes();
        supportedBuffer = new StringBuilder();
        notSupportedBuffer = new StringBuilder();
        for (int i = 0; i < supportedTokens.length; ++i) {
            if (supportedTokens[i].isSupported()) {
                supportedBuffer.append(this.getUri(supportedTokens[i].getTokenType()));
                continue;
            }
            notSupportedBuffer.append(this.getUri(supportedTokens[i].getTokenType()));
        }
        Registry registry = null;
        registry = IdentityTenantUtil.getRegistry();
        dbAmin.createOrUpdateParameter(registry, "SupportedTokenTypes", supportedBuffer.toString());
        dbAmin.createOrUpdateParameter(IdentityTenantUtil.getRegistry(), "NotSupportedTokenTypes", notSupportedBuffer.toString());
        dbAmin.createOrUpdateParameter(registry, "CardName", issuer.getCardName());
        dbAmin.createOrUpdateParameter(registry, "ValidPeriod", String.valueOf(issuer.getValidPeriodInDays()));
        dbAmin.createOrUpdateParameter(registry, "useSymmBinding", String.valueOf(issuer.isSymmetricBinding()));
    }

    private String getUri(String tokenType) {
        if ("SAML10".equals(tokenType)) {
            return "urn:oasis:names:tc:SAML:1.0:assertion,";
        }
        if ("SAML11".equals(tokenType)) {
            return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1,";
        }
        if ("SAML20".equals(tokenType)) {
            return "urn:oasis:names:tc:SAML:2.0:assertion,";
        }
        if ("OpenID".equals(tokenType)) {
            return "http://specs.openid.net/auth/2.0,";
        }
        return tokenType + ",";
    }

    private String getTokenType(String uri) {
        if (uri.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
            return "SAML10";
        }
        if (uri.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
            return "SAML11";
        }
        if (uri.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            return "SAML20";
        }
        if (uri.equals("http://specs.openid.net/auth/2.0")) {
            return "OpenID";
        }
        return uri;
    }

    private void addParameters(Registry registry) throws IdentityException {
        IdentityPersistenceManager admin = IdentityPersistenceManager.getPersistanceManager();
        admin.createOrUpdateParameter(registry, "SupportedTokenTypes", "urn:oasis:names:tc:SAML:1.0:assertion,http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1,urn:oasis:names:tc:SAML:2.0:assertion,http://specs.openid.net/auth/2.0");
        admin.createOrUpdateParameter(registry, "CardName", "WSO2 Managed Card");
        admin.createOrUpdateParameter(registry, "ValidPeriod", "365");
    }
}

