/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.sts.mgt.internal.IdentitySTSMgtServiceComponent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IPPasswordCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(IPPasswordCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) continue;
                WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[i];
                String username = pwcb.getIdentifer();
                int value = pwcb.getUsage();
                String receivedPasswd = pwcb.getPassword();
                if (5 != value || receivedPasswd != null && this.authenticateUser(username, receivedPasswd)) continue;
                throw new UnsupportedCallbackException(callbacks[i], "check failed");
            }
        }
        catch (UnsupportedCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("User not authenticated : " + e.getMessage()), (Throwable)e);
            throw new IOException("User not authenticated");
        }
    }

    public boolean authenticateUser(String userName, String password) throws CarbonException, UserStoreException {
        RealmService realmService = IdentitySTSMgtServiceComponent.getRealmService();
        RegistryService registryService = IdentitySTSMgtServiceComponent.getRegistryService();
        boolean isAuthenticated = false;
        UserRealm realm = AnonymousSessionUtil.getRealmByUserName((RegistryService)registryService, (RealmService)realmService, (String)userName);
        String tenantFreeUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
        isAuthenticated = realm.getUserStoreManager().authenticate(tenantFreeUsername, (Object)password);
        return isAuthenticated;
    }
}

