/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.constants.TenantConstants;
import org.wso2.carbon.stratos.common.exception.TenantManagementClientException;
import org.wso2.carbon.stratos.common.exception.TenantManagementServerException;
import org.wso2.carbon.stratos.common.internal.CloudCommonServiceComponent;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static StratosConfiguration stratosConfig;
    private static String eula;
    private static final String ILLEGAL_CHARACTERS_FOR_EMAIL = ".*[\\(\\)\\<\\>\\,\\;\\:\\\\\\\"\\[\\]].*";
    private static final String EMAIL_FILTER_STRING = "^[^@]+@[^@.]+\\.[^@]*\\w\\w$";
    private static Pattern emailFilterPattern;
    private static Pattern illegalCharactersPatternForEmail;

    public static StratosConfiguration getStratosConfig() {
        return stratosConfig;
    }

    public static void setStratosConfig(StratosConfiguration stratosConfig) {
        CommonUtil.stratosConfig = stratosConfig;
    }

    public static String getEula() {
        return eula;
    }

    public static void setEula(String eula) {
        CommonUtil.eula = eula;
    }

    public static boolean isEmailValidationMandatory() {
        boolean isEmailValidationMandatory = false;
        if (stratosConfig != null) {
            isEmailValidationMandatory = stratosConfig.getEmailValidationRequired();
        }
        return isEmailValidationMandatory;
    }

    public static boolean isTenantManagementEmailsDisabled() {
        boolean isEmailsDisabled = true;
        if (stratosConfig != null) {
            isEmailsDisabled = stratosConfig.isEmailsDisabled();
        }
        return isEmailsDisabled;
    }

    public static String getSuperAdminEmail() {
        return stratosConfig.getSuperAdminEmail();
    }

    public static String getAdminUserName() {
        return stratosConfig.getAdminUserName();
    }

    public static String getAdminPassword() {
        return stratosConfig.getAdminPassword();
    }

    public static boolean isTenantActivationModerated() {
        return stratosConfig.isTenantActivationModerated();
    }

    public static boolean isChargedOnRegistration() {
        return stratosConfig.isChargeOnRegistration();
    }

    public static boolean isPublicCloudSetup() {
        boolean isPublicCloudSetup = true;
        if (stratosConfig != null) {
            isPublicCloudSetup = stratosConfig.isPublicCloudSetup();
        }
        return isPublicCloudSetup;
    }

    public static String getNotificationEmailAddress() {
        String notificationEmailAddress = "";
        if (stratosConfig != null) {
            notificationEmailAddress = stratosConfig.getNotificationEmail();
            try {
                CommonUtil.validateEmail(notificationEmailAddress);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Invalid Email Address provided for tenant creation notification. Please check whether the parameter NotificationEmail is set properly in stratos.xml", (Throwable)e);
                }
                return "";
            }
        }
        return notificationEmailAddress;
    }

    public static String getMonthString(Calendar calendar) {
        int currentMonth = calendar.get(2);
        String[] monthArr = new DateFormatSymbols().getMonths();
        String month = monthArr[currentMonth];
        return calendar.get(1) + "-" + month;
    }

    public static String getMonthString(int relativeMonth) {
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.add(2, relativeMonth);
        return CommonUtil.getMonthString(newCalendar);
    }

    public static Date getDateFromMonthString(String yearMonth) throws ParseException {
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MMM");
        return yearMonthFormat.parse(yearMonth);
    }

    public static String getCurrentMonthString() {
        Calendar newCalendar = Calendar.getInstance();
        return CommonUtil.getMonthString(newCalendar);
    }

    public static void setAnonAuthorization(String path, UserRealm userRealm) throws RegistryException {
        if (userRealm == null) {
            return;
        }
        try {
            AuthorizationManager accessControlAdmin = userRealm.getAuthorizationManager();
            String everyoneRole = "system/wso2.anonymous.role";
            accessControlAdmin.authorizeRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/get");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/add");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/delete");
            accessControlAdmin.denyRole(everyoneRole, path, "authorize");
        }
        catch (UserStoreException e) {
            String msg = "Could not set authorizations for the " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }

    public static void denyAnonAuthorization(String path, UserRealm userRealm) throws RegistryException {
        if (userRealm == null) {
            return;
        }
        try {
            RealmConfiguration realmConfig;
            AuthorizationManager accessControlAdmin = userRealm.getAuthorizationManager();
            try {
                realmConfig = userRealm.getRealmConfiguration();
            }
            catch (UserStoreException e) {
                String msg = "Failed to retrieve realm configuration.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            String everyoneRole = realmConfig.getEveryOneRoleName();
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/get");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/add");
            accessControlAdmin.denyRole(everyoneRole, path, "http://www.wso2.org/projects/registry/actions/delete");
            accessControlAdmin.denyRole(everyoneRole, path, "authorize");
        }
        catch (UserStoreException e) {
            String msg = "Could not clear authorizations for the " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }

    public static OMElement buildOMElement(InputStream inputStream) throws Exception {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static void validateEmail(String email) throws Exception {
        if (StringUtils.isBlank((String)email)) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_EMPTY_EMAIL);
        }
        if (illegalCharactersPatternForEmail.matcher(email).matches()) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_ILLEGAL_EMAIL);
        }
        if (!emailFilterPattern.matcher(email).matches()) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_INVALID_EMAIL);
        }
    }

    public static void validateName(String name, String variable) throws Exception {
        if (name.trim().equals("")) {
            String msg = variable + " is not provided.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    public static boolean validateDomainFromSuccessKey(UserRegistry governanceSystemRegistry, String domain, String successKey) throws RegistryException {
        Resource resource;
        String actualSuccessKey;
        String domainValidatorInfoPath = "/repository/components/org.wso2.carbon.domain-validator-info/" + domain + "/" + "validation-key";
        return governanceSystemRegistry.resourceExists(domainValidatorInfoPath) && (actualSuccessKey = (resource = governanceSystemRegistry.get(domainValidatorInfoPath)).getProperty("successKey")) != null && successKey != null && actualSuccessKey.trim().equals(successKey.trim());
    }

    public static StratosConfiguration loadStratosConfiguration() {
        String StratosConfigFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + "stratos.xml";
        return CommonUtil.loadStratosConfiguration(StratosConfigFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StratosConfiguration loadStratosConfiguration(String configFilename) {
        StratosConfiguration config = new StratosConfiguration();
        File configFile = new File(configFilename);
        if (configFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(configFile);
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildElements();
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    if ("DisableTenantManagementEmails".equals(element.getLocalName())) {
                        String disableEmails = element.getText();
                        boolean isEmailsDisabled = true;
                        if (disableEmails.trim().equalsIgnoreCase("false")) {
                            isEmailsDisabled = false;
                        }
                        config.setEmailsDisabled(isEmailsDisabled);
                        continue;
                    }
                    if ("EmailValidationMandatoryForLogin".equals(element.getLocalName())) {
                        String emailValidation = element.getText();
                        boolean isEmailValidationRequired = false;
                        if (emailValidation.trim().equalsIgnoreCase("true")) {
                            isEmailValidationRequired = true;
                        }
                        config.setEmailValidationRequired(isEmailValidationRequired);
                        continue;
                    }
                    if ("ChargeOnRegistration".equals(element.getLocalName())) {
                        String chargeOnRegistration = element.getText();
                        boolean isChargedOnRegistration = false;
                        if (chargeOnRegistration.trim().equalsIgnoreCase("true")) {
                            isChargedOnRegistration = true;
                        }
                        config.setChargeOnRegistration(isChargedOnRegistration);
                        continue;
                    }
                    if ("NotificationEmail".equals(element.getLocalName())) {
                        config.setNotificationEmail(element.getText());
                        continue;
                    }
                    if ("SuperAdminEmail".equals(element.getLocalName())) {
                        config.setSuperAdminEmail(element.getText());
                        continue;
                    }
                    if ("TenantActivationModerated".equals(element.getLocalName())) {
                        String isTenantActivationModerated = element.getText();
                        boolean tenantActivationModerated = false;
                        if (isTenantActivationModerated.trim().equalsIgnoreCase("true")) {
                            tenantActivationModerated = true;
                        }
                        config.setTenantActivationModerated(tenantActivationModerated);
                        continue;
                    }
                    if ("StratosPublicCloudSetup".equals(element.getLocalName())) {
                        String cloudSetup = element.getText();
                        boolean isStratosPublicCloudSetup = true;
                        if (cloudSetup.trim().equalsIgnoreCase("false")) {
                            isStratosPublicCloudSetup = false;
                        }
                        config.setPublicCloudSetup(isStratosPublicCloudSetup);
                        continue;
                    }
                    if ("PaypalUrl".equals(element.getLocalName())) {
                        String paypalUrl = element.getText();
                        config.setPaypalUrl(paypalUrl);
                        continue;
                    }
                    if ("SkipSummaryGenerator".equals(element.getLocalName())) {
                        String summaryGenerator = element.getText();
                        boolean skipSummaryGenerator = false;
                        if (summaryGenerator.trim().equalsIgnoreCase("true")) {
                            skipSummaryGenerator = true;
                        }
                        config.setSkipSummaryGenerator(skipSummaryGenerator);
                        continue;
                    }
                    if ("PaypalAPIUsername".equals(element.getLocalName())) {
                        config.setPaypalAPIUsername(element.getText());
                        continue;
                    }
                    if ("PaypalAPIPassword".equals(element.getLocalName())) {
                        config.setPaypalAPIPassword(element.getText());
                        continue;
                    }
                    if ("PaypalAPISignature".equals(element.getLocalName())) {
                        config.setPaypalAPISignature(element.getText());
                        continue;
                    }
                    if ("PaypalEnvironment".equals(element.getLocalName())) {
                        config.setPaypalEnvironment(element.getText());
                        continue;
                    }
                    if ("FinanceNotificationEmail".equals(element.getLocalName())) {
                        config.setFinanceNotificationEmail(element.getText());
                        continue;
                    }
                    if ("UsagePlanUrl".equals(element.getLocalName())) {
                        config.setUsagePlanURL(element.getText());
                        continue;
                    }
                    if ("PaidJIRAUrl".equals(element.getLocalName())) {
                        config.setPaidJIRAUrl(element.getText());
                        continue;
                    }
                    if ("PaidJIRAProject".equals(element.getLocalName())) {
                        config.setPaidJIRAProject(element.getText());
                        continue;
                    }
                    if ("ForumUrl".equals(element.getLocalName())) {
                        config.setForumUrl(element.getText());
                        continue;
                    }
                    if ("PaidUserGroup".equals(element.getLocalName())) {
                        config.setPaidUserGroup(element.getText());
                        continue;
                    }
                    if ("NonpaidUserGroup".equals(element.getLocalName())) {
                        config.setNonpaidUserGroup(element.getText());
                        continue;
                    }
                    if ("SupportInfoUrl".equals(element.getLocalName())) {
                        config.setSupportInfoUrl(element.getText());
                        continue;
                    }
                    if ("IncidentCustomFieldId".equals(element.getLocalName())) {
                        config.setIncidentCustomFieldId(element.getText());
                        continue;
                    }
                    if ("IncidentImpactCustomFieldId".equals(element.getLocalName())) {
                        config.setIncidentImpactCustomFieldId(element.getText());
                        continue;
                    }
                    if ("GoogleAnalyticsURL".equals(element.getLocalName())) {
                        config.setGoogleAnalyticsURL(element.getText());
                        continue;
                    }
                    if ("StratosEventListener".equals(element.getLocalName())) {
                        CommonUtil.populateEventListenerProperties(config, element);
                        continue;
                    }
                    if ("managerServiceUrl".equals(element.getLocalName())) {
                        config.setManagerServiceUrl(element.getText());
                        continue;
                    }
                    if ("adminUserName".equals(element.getLocalName())) {
                        config.setAdminUserName(element.getText());
                        continue;
                    }
                    if ("adminPassword".equals(element.getLocalName())) {
                        config.setAdminPassword(element.getText());
                        continue;
                    }
                    if (!"SSOLoadingMessage".equals(element.getLocalName())) continue;
                    config.setSsoLoadingMessage(element.getText());
                }
                StratosConfiguration stratosConfiguration = config;
                return stratosConfiguration;
            }
            catch (Exception e) {
                String msg = "Error in loading Stratos Configurations File: " + configFilename + ".";
                log.error((Object)msg, (Throwable)e);
                StratosConfiguration stratosConfiguration = config;
                return stratosConfiguration;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close the Configuration File " + configFilename));
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to locate the stratos configurations file. Default Settings will be used.");
        }
        return config;
    }

    private static void populateEventListenerProperties(StratosConfiguration config, OMElement element) throws RegistryException {
        config.setStratosEventListenerName(element.getAttributeValue(new QName("class")));
        Iterator ite = element.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            config.setStratosEventListenerProperty(propName, propValue);
        }
    }

    public static String loadTermsOfUsage() {
        String StratosEULAFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + "eula.xml";
        return CommonUtil.loadTermsOfUsage(StratosEULAFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadTermsOfUsage(String eulaFile) {
        String eula = "Please refer to: http://wso2.com/cloud/services/terms-of-use/ for terms and usage and http://wso2.com/cloud/services/privacy-policy/ for privacy policy of WSO2 Stratos.";
        File configFile = new File(eulaFile);
        if (configFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(configFile);
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildElements();
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    if (!"EULA".equalsIgnoreCase(element.getLocalName())) continue;
                    eula = element.getText();
                }
                String string = eula;
                return string;
            }
            catch (Exception e) {
                String msg = "Error in loading Stratos Terms and Conditions File.";
                log.error((Object)msg, (Throwable)e);
                String string = eula;
                return string;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close the EULA File " + eulaFile));
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to locate the stratos EULA file. Default value will be used.");
        }
        return eula;
    }

    public static boolean isDomainNameAvailable(String tenantDomain) throws Exception {
        int tenantId;
        TenantManager tenantManager = CloudCommonServiceComponent.getTenantManager();
        if (tenantDomain.equals("atom") || tenantDomain.equals("registry") || tenantDomain.equals("resource")) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_UNAVAILABLE_DOMAIN);
        }
        try {
            tenantId = tenantManager.getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the tenant id for the given domain  " + tenantDomain + ".";
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
        if (tenantId != -1 && tenantId != -1234 || tenantDomain.equals("carbon.super")) {
            String msg = "A tenant with same domain already exist. Please use a different domain name. tenant domain: " + tenantDomain + ".";
            log.info((Object)msg);
            return false;
        }
        return true;
    }

    static {
        emailFilterPattern = Pattern.compile(EMAIL_FILTER_STRING);
        illegalCharactersPatternForEmail = Pattern.compile(ILLEGAL_CHARACTERS_FOR_EMAIL);
    }
}

