/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.common.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.common.config.CloudServiceConfig;

public class CloudServicesDescConfig {
    private static final Log log = LogFactory.getLog(CloudServicesDescConfig.class);
    private static final String CONFIG_NS = "http://wso2.com/carbon/cloud/mgt/services";
    private static final String CLOUD_SERVICE_ELEMENT_NAME = "cloudService";
    Map<String, CloudServiceConfig> cloudServiceConfigs = new LinkedHashMap<String, CloudServiceConfig>();

    public CloudServicesDescConfig(OMElement configEle) {
        this.serialize(configEle);
    }

    public void serialize(OMElement configEle) {
        Iterator configChildIt = configEle.getChildElements();
        while (configChildIt.hasNext()) {
            OMElement configChildEle;
            Object configChildObj = configChildIt.next();
            if (!(configChildObj instanceof OMElement) || !new QName(CONFIG_NS, CLOUD_SERVICE_ELEMENT_NAME, "").equals((configChildEle = (OMElement)configChildObj).getQName())) continue;
            CloudServiceConfig cloudServiceConfig = new CloudServiceConfig(configChildEle);
            String name = cloudServiceConfig.getName();
            this.cloudServiceConfigs.put(name, cloudServiceConfig);
        }
    }

    public Map<String, CloudServiceConfig> getCloudServiceConfigs() {
        return this.cloudServiceConfigs;
    }
}

