/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.common.config;

import java.io.File;
import java.io.FileInputStream;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.common.config.CloudServicesDescConfig;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class CloudServiceConfigParser {
    private static Log log = LogFactory.getLog(CloudServiceConfigParser.class);
    private static final SynchronizingClass loadlock = new SynchronizingClass();
    private static CloudServicesDescConfig cloudServicesDescConfig = null;
    private static final String CONFIG_FILENAME = "cloud-services-desc.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudServicesDescConfig loadCloudServicesConfiguration() throws Exception {
        if (cloudServicesDescConfig != null) {
            return cloudServicesDescConfig;
        }
        SynchronizingClass synchronizingClass = loadlock;
        synchronized (synchronizingClass) {
            if (cloudServicesDescConfig == null) {
                try {
                    String configFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + CONFIG_FILENAME;
                    OMElement configElement = CommonUtil.buildOMElement(new FileInputStream(configFileName));
                    cloudServicesDescConfig = new CloudServicesDescConfig(configElement);
                }
                catch (Exception e) {
                    String msg = "Error in building the cloud service configuration.";
                    log.error((Object)msg, (Throwable)e);
                    throw new Exception(msg, e);
                }
            }
        }
        return cloudServicesDescConfig;
    }

    private static class SynchronizingClass {
        private SynchronizingClass() {
        }
    }
}

