/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.claim.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.claim.mgt.internal.ClaimManagementServiceDataHolder;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="claim.mgt.component", immediate=true)
public class ClaimManagementServiceComponent {
    private static final Log log = LogFactory.getLog(ClaimManagementServiceComponent.class);

    public static BundleContext getBundleContext() {
        return ClaimManagementServiceDataHolder.getInstance().getBundleContext();
    }

    public static RealmService getRealmService() {
        return ClaimManagementServiceDataHolder.getInstance().getRealmService();
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        try {
            ClaimManagementServiceDataHolder.getInstance().setRealmService(realmService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Realm Service.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService set in Claim Management bundle");
        }
    }

    public static RegistryService getRegistryService() {
        return ClaimManagementServiceDataHolder.getInstance().getRegistryService();
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        try {
            ClaimManagementServiceDataHolder.getInstance().setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry Service.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Claim Management bundle");
        }
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            ClaimManagementServiceDataHolder.getInstance().setBundleContext(ctxt.getBundleContext());
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating Claim Management Service Component", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Claim Management Core bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Claim Management bundle is deactivated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ClaimManagementServiceDataHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Claim Management bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        ClaimManagementServiceDataHolder.getInstance().setRealmService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService unset in Claim Management bundle");
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

