/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.claim.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.claim.mgt.ClaimDialect;
import org.wso2.carbon.claim.mgt.ClaimManagementException;
import org.wso2.carbon.claim.mgt.ClaimMapping;
import org.wso2.carbon.claim.mgt.internal.ClaimManagementServiceComponent;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementServiceImpl;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.service.RealmService;

public enum ClaimManagerHandler {
    INSTANCE;

    private static final Log log;

    public static ClaimManagerHandler getInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ClaimManagerHandler singleton instance created successfully");
        }
        return INSTANCE;
    }

    public Claim[] getAllSupportedClaims() throws ClaimManagementException {
        try {
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager != null) {
                org.wso2.carbon.user.api.ClaimMapping[] mappings = realm.getClaimManager().getAllSupportClaimMappingsByDefault();
                Claim[] claims = new Claim[mappings.length];
                for (int i = 0; i < mappings.length; ++i) {
                    claims[i] = mappings[i].getClaim();
                }
                return claims;
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading supported claims", e);
        }
        return new Claim[0];
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllSupportedClaimMappings() throws ClaimManagementException {
        try {
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return new org.wso2.carbon.user.api.ClaimMapping[0];
            }
            return claimManager.getAllSupportClaimMappingsByDefault();
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading supported claims", e);
        }
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings() throws ClaimManagementException {
        try {
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return new org.wso2.carbon.user.api.ClaimMapping[0];
            }
            return claimManager.getAllClaimMappings();
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading supported claims", e);
        }
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings(String tenantDomain) throws ClaimManagementException {
        try {
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)ClaimManagementServiceComponent.getRegistryService(), (RealmService)ClaimManagementServiceComponent.getRealmService(), (String)tenantDomain);
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return new org.wso2.carbon.user.api.ClaimMapping[0];
            }
            return claimManager.getAllClaimMappings();
        }
        catch (CarbonException | UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading claims mapping for tenant " + tenantDomain, e);
        }
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings(String dialectURI, String tenantDomain) throws ClaimManagementException {
        try {
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)ClaimManagementServiceComponent.getRegistryService(), (RealmService)ClaimManagementServiceComponent.getRealmService(), (String)tenantDomain);
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return new org.wso2.carbon.user.api.ClaimMapping[0];
            }
            return claimManager.getAllClaimMappings(dialectURI);
        }
        catch (CarbonException | UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading all claim mappings for tenant " + tenantDomain, e);
        }
    }

    public org.wso2.carbon.user.api.ClaimMapping getClaimMapping(String claimURI) throws ClaimManagementException {
        org.wso2.carbon.user.api.ClaimMapping claimMapping = null;
        try {
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager != null) {
                claimMapping = claimManager.getClaimMapping(claimURI);
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while retrieving claim", e);
        }
        return claimMapping;
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllSupportedClaimMappings(String dialectUri) throws ClaimManagementException {
        try {
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return new org.wso2.carbon.user.api.ClaimMapping[0];
            }
            return claimManager.getAllClaimMappings(dialectUri);
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading supported claims", e);
        }
    }

    public Claim[] getAllSupportedClaims(String dialectUri) throws ClaimManagementException {
        Claim[] claims = new Claim[]{};
        ArrayList<Claim> reqClaims = null;
        ClaimManager claimManager = null;
        org.wso2.carbon.user.api.ClaimMapping[] mappings = null;
        try {
            UserRealm realm = this.getRealm();
            claimManager = realm.getClaimManager();
            if (claimManager == null) {
                return claims;
            }
            mappings = claimManager.getAllSupportClaimMappingsByDefault();
            reqClaims = new ArrayList<Claim>();
            for (org.wso2.carbon.user.api.ClaimMapping mapping : mappings) {
                Claim claim = mapping.getClaim();
                if (!dialectUri.equals(claim.getDialectURI())) continue;
                reqClaims.add(claim);
            }
            return reqClaims.toArray(new Claim[reqClaims.size()]);
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while loading supported claims from the dialect " + dialectUri, e);
        }
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws ClaimManagementException {
        ClaimManager claimManager = null;
        try {
            UserRealm realm = this.getRealm();
            String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
            if (primaryDomainName == null) {
                if (mapping.getMappedAttribute() == null) {
                    throw new ClaimManagementException("Attribute name cannot be null for the primary domain");
                }
            } else if (mapping.getMappedAttribute() == null) {
                String attr = mapping.getMappedAttribute(primaryDomainName);
                if (attr == null) {
                    throw new ClaimManagementException("Attribute name cannot be null for the primary domain");
                }
                mapping.setMappedAttribute(attr);
            }
            if ((claimManager = realm.getClaimManager()) != null) {
                claimManager.updateClaimMapping(mapping);
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while updating claim mapping", e);
        }
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws ClaimManagementException {
        ClaimManager claimManager = null;
        try {
            UserRealm realm = this.getRealm();
            claimManager = realm.getClaimManager();
            if (claimManager != null) {
                claimManager.addNewClaimMapping(mapping);
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while adding new claim mapping", e);
        }
    }

    public void removeClaimMapping(String dialectUri, String claimUri) throws ClaimManagementException {
        org.wso2.carbon.user.api.ClaimMapping mapping = null;
        Claim claim = null;
        ClaimManager claimManager = null;
        try {
            UserRealm realm = this.getRealm();
            claimManager = realm.getClaimManager();
            if (claimManager != null) {
                claim = new Claim();
                claim.setClaimUri(claimUri);
                claim.setDialectURI(dialectUri);
                mapping = new org.wso2.carbon.user.api.ClaimMapping(claim, null);
                claimManager.deleteClaimMapping(mapping);
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while removing new claim mapping", e);
        }
    }

    public void addNewClaimDialect(ClaimDialect mappings) throws ClaimManagementException {
        ClaimManager claimManager = null;
        try {
            UserRealm realm = this.getRealm();
            claimManager = realm.getClaimManager();
            if (claimManager != null) {
                org.wso2.carbon.user.api.ClaimMapping[] mapping;
                for (org.wso2.carbon.user.api.ClaimMapping aMapping : mapping = mappings.getClaimMapping()) {
                    claimManager.addNewClaimMapping(aMapping);
                }
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while removing new claim mapping", e);
        }
    }

    public void removeClaimDialect(String dialectUri) throws ClaimManagementException {
        try {
            org.wso2.carbon.user.api.ClaimMapping[] mapping;
            UserRealm realm = this.getRealm();
            ClaimManager claimManager = realm.getClaimManager();
            if (claimManager != null && (mapping = claimManager.getAllClaimMappings(dialectUri)) != null) {
                for (org.wso2.carbon.user.api.ClaimMapping aMapping : mapping) {
                    claimManager.deleteClaimMapping(aMapping);
                }
            }
        }
        catch (UserStoreException e) {
            throw new ClaimManagementException("Error occurred while removing new claim dialect", e);
        }
    }

    private UserRealm getRealm() throws ClaimManagementException {
        try {
            return AdminServicesUtil.getUserRealm();
        }
        catch (CarbonException e) {
            throw new ClaimManagementException("Error while trying get User Realm.", e);
        }
    }

    public Set<ClaimMapping> getMappingsFromCarbonDialectToOther(String otherDialectURI, Set<String> carbonClaimURIs, String tenantDomain) throws ClaimManagementException {
        HashSet<ClaimMapping> returnSet = new HashSet<ClaimMapping>();
        if ("http://wso2.org/claims".equals(otherDialectURI)) {
            for (String claimURI : carbonClaimURIs) {
                ClaimMapping claimMapping = new ClaimMapping(otherDialectURI, claimURI, claimURI);
                returnSet.add(claimMapping);
            }
            return returnSet;
        }
        org.wso2.carbon.user.api.ClaimMapping[] claimMappingsInOtherDialect = this.getAllClaimMappings(otherDialectURI, tenantDomain);
        org.wso2.carbon.user.api.ClaimMapping[] allClaimMappingsInCarbonDialect = this.getAllClaimMappings("http://wso2.org/claims", tenantDomain);
        if (otherDialectURI == null) {
            String message = "Invalid argument: 'otherDialectURI' is 'NULL'";
            log.error((Object)message);
            throw new ClaimManagementException(message);
        }
        if (carbonClaimURIs == null || carbonClaimURIs.isEmpty()) {
            String message = "Invalid argument: 'carbonClaimURIs' is 'NULL' or of zero length";
            log.error((Object)message);
            throw new ClaimManagementException(message);
        }
        for (String requestedClaimURI : carbonClaimURIs) {
            if (allClaimMappingsInCarbonDialect == null || allClaimMappingsInCarbonDialect.length <= 0) continue;
            for (org.wso2.carbon.user.api.ClaimMapping claimMapping : allClaimMappingsInCarbonDialect) {
                if (!requestedClaimURI.equals(claimMapping.getClaim().getClaimUri())) continue;
                String mappedAttr = claimMapping.getMappedAttribute();
                for (org.wso2.carbon.user.api.ClaimMapping carbonClaimMapping : claimMappingsInOtherDialect) {
                    if (!mappedAttr.equals(carbonClaimMapping.getMappedAttribute())) continue;
                    returnSet.add(new ClaimMapping(otherDialectURI, requestedClaimURI, carbonClaimMapping.getClaim().getClaimUri()));
                }
            }
        }
        return returnSet;
    }

    public Map<String, String> getMappingsMapFromCarbonDialectToOther(String otherDialectURI, Set<String> carbonClaimURIs, String tenantDomain) throws ClaimManagementException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Set<ClaimMapping> mappings = this.getMappingsFromCarbonDialectToOther(otherDialectURI, carbonClaimURIs, tenantDomain);
        for (ClaimMapping mapping : mappings) {
            returnMap.put(mapping.getCarbonClaimURI(), mapping.getNonCarbonClaimURI());
        }
        return returnMap;
    }

    public Set<ClaimMapping> getMappingsFromOtherDialectToCarbon(String otherDialectURI, Set<String> otherClaimURIs, String tenantDomain) throws ClaimManagementException {
        HashSet<ClaimMapping> returnSet = new HashSet<ClaimMapping>();
        if (otherDialectURI == null) {
            String message = "Invalid argument: 'otherDialectURI' is 'NULL'";
            log.error((Object)message);
            throw new ClaimManagementException(message);
        }
        try {
            ClaimMetadataManagementServiceImpl claimMetadataService = new ClaimMetadataManagementServiceImpl();
            if (otherDialectURI.equals("http://wso2.org/claims")) {
                List localClaims = claimMetadataService.getLocalClaims(tenantDomain);
                if (otherClaimURIs == null || otherClaimURIs.isEmpty()) {
                    for (LocalClaim localClaim : localClaims) {
                        ClaimMapping claimMapping = new ClaimMapping(localClaim.getClaimDialectURI(), localClaim.getClaimURI(), localClaim.getClaimURI());
                        returnSet.add(claimMapping);
                    }
                    return returnSet;
                }
                for (LocalClaim localClaim : localClaims) {
                    if (!otherClaimURIs.contains(localClaim.getClaimURI())) continue;
                    ClaimMapping claimMapping = new ClaimMapping(otherDialectURI, localClaim.getClaimURI(), localClaim.getClaimURI());
                    returnSet.add(claimMapping);
                }
                return returnSet;
            }
            List externalClaims = claimMetadataService.getExternalClaims(otherDialectURI, tenantDomain);
            if (otherClaimURIs == null || otherClaimURIs.isEmpty()) {
                for (ExternalClaim externalClaim : externalClaims) {
                    ClaimMapping claimMapping = new ClaimMapping(externalClaim.getClaimDialectURI(), externalClaim.getClaimURI(), externalClaim.getMappedLocalClaim());
                    returnSet.add(claimMapping);
                }
            } else {
                for (ExternalClaim externalClaim : externalClaims) {
                    if (!otherClaimURIs.contains(externalClaim.getClaimURI())) continue;
                    ClaimMapping claimMapping = new ClaimMapping(externalClaim.getClaimDialectURI(), externalClaim.getClaimURI(), externalClaim.getMappedLocalClaim());
                    returnSet.add(claimMapping);
                }
            }
            return returnSet;
        }
        catch (ClaimMetadataException e) {
            throw new ClaimManagementException(e.getMessage(), e);
        }
    }

    public Map<String, String> getMappingsMapFromOtherDialectToCarbon(String otherDialectURI, Set<String> otherClaimURIs, String tenantDomain) throws ClaimManagementException {
        return this.getMappingsMapFromOtherDialectToCarbon(otherDialectURI, otherClaimURIs, tenantDomain, false);
    }

    public Map<String, String> getMappingsMapFromOtherDialectToCarbon(String otherDialectURI, Set<String> otherClaimURIs, String tenantDomain, boolean useCarbonDialectAsKey) throws ClaimManagementException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Set<ClaimMapping> mappings = this.getMappingsFromOtherDialectToCarbon(otherDialectURI, otherClaimURIs, tenantDomain);
        for (ClaimMapping mapping : mappings) {
            if (useCarbonDialectAsKey) {
                returnMap.put(mapping.getCarbonClaimURI(), mapping.getNonCarbonClaimURI());
                continue;
            }
            returnMap.put(mapping.getNonCarbonClaimURI(), mapping.getCarbonClaimURI());
        }
        return returnMap;
    }

    public Set<String> getAllClaimDialects(String tenantDomain) throws ClaimManagementException {
        HashSet<String> dialects = new HashSet<String>();
        ArrayList<org.wso2.carbon.user.api.ClaimMapping> claimMappings = new ArrayList<org.wso2.carbon.user.api.ClaimMapping>(Arrays.asList(this.getAllClaimMappings(tenantDomain)));
        if (claimMappings.isEmpty()) {
            return new HashSet<String>();
        }
        for (org.wso2.carbon.user.api.ClaimMapping claimMapping : claimMappings) {
            String dialectUri = claimMapping.getClaim().getDialectURI();
            dialects.add(dialectUri);
        }
        return dialects;
    }

    public boolean isKnownClaimDialect(String dialectURI, String tenantDomain) throws ClaimManagementException {
        if (StringUtils.isEmpty((String)dialectURI)) {
            String message = "Invalid argument : 'dialectURI' is 'NULL' or empty";
            throw new IllegalArgumentException(message);
        }
        return this.getAllClaimDialects(tenantDomain).contains(dialectURI);
    }

    private Set<String> validateClaims(Set<String> attributeKeys) {
        String claimURI;
        if (attributeKeys != null && !attributeKeys.isEmpty() && !(claimURI = new ArrayList<String>(attributeKeys).get(0)).startsWith("http://wso2.org/claims")) {
            return new HashSet<String>();
        }
        return attributeKeys;
    }

    static {
        log = LogFactory.getLog(ClaimManagerHandler.class);
    }
}

