/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.claim.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.claim.mgt.ClaimDialect;
import org.wso2.carbon.claim.mgt.ClaimManagementException;
import org.wso2.carbon.claim.mgt.ClaimManagerHandler;
import org.wso2.carbon.claim.mgt.dto.ClaimAttributeDTO;
import org.wso2.carbon.claim.mgt.dto.ClaimDTO;
import org.wso2.carbon.claim.mgt.dto.ClaimDialectDTO;
import org.wso2.carbon.claim.mgt.dto.ClaimMappingDTO;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;

public class ClaimAdminService {
    public ClaimDialectDTO[] getClaimMappings() throws ClaimManagementException {
        ClaimMapping[] claimMappings = null;
        List<ClaimMapping> mappingList = null;
        HashMap claimMap = null;
        ArrayList<ClaimDialect> claims = null;
        ClaimDialect dto = null;
        claimMappings = ClaimManagerHandler.getInstance().getAllClaimMappings();
        if (claimMappings == null || claimMappings.length == 0) {
            return new ClaimDialectDTO[0];
        }
        claimMap = new HashMap();
        claims = new ArrayList<ClaimDialect>();
        for (int i = 0; i < claimMappings.length; ++i) {
            String dialectUri = claimMappings[i].getClaim().getDialectURI();
            if (!claimMap.containsKey(dialectUri)) {
                mappingList = new ArrayList<ClaimMapping>();
                mappingList.add(claimMappings[i]);
                claimMap.put(dialectUri, mappingList);
                continue;
            }
            mappingList = (List)claimMap.get(dialectUri);
            mappingList.add(claimMappings[i]);
        }
        for (Map.Entry entry : claimMap.entrySet()) {
            mappingList = (List)entry.getValue();
            dto = new ClaimDialect();
            ClaimMapping[] claimMappingArray = mappingList.toArray(new ClaimMapping[mappingList.size()]);
            Arrays.sort(claimMappingArray, new Comparator<ClaimMapping>(){

                @Override
                public int compare(ClaimMapping o1, ClaimMapping o2) {
                    return o1.getClaim().getDescription().toLowerCase().compareTo(o2.getClaim().getDescription().toLowerCase());
                }
            });
            dto.setClaimMapping(claimMappingArray);
            dto.setDialectUri((String)entry.getKey());
            claims.add(dto);
        }
        return this.convertClaimDialectArrayToClaimDialectDTOArray(claims.toArray(new ClaimDialect[claims.size()]));
    }

    public ClaimDialectDTO getClaimMappingByDialect(String dialectUri) throws ClaimManagementException {
        ClaimMapping[] claimMappings = ClaimManagerHandler.getInstance().getAllSupportedClaimMappings(dialectUri);
        Arrays.sort(claimMappings, new Comparator<ClaimMapping>(){

            @Override
            public int compare(ClaimMapping claimMapping1, ClaimMapping claimMapping2) {
                return claimMapping1.getClaim().getDescription().toLowerCase().compareTo(claimMapping2.getClaim().getDescription().toLowerCase());
            }
        });
        if (claimMappings.length == 0) {
            return null;
        }
        ClaimDialect claimDialect = new ClaimDialect();
        claimDialect.setClaimMapping(claimMappings);
        claimDialect.setDialectUri(dialectUri);
        return this.convertClaimDialectToClaimDialectDTO(claimDialect);
    }

    public void upateClaimMapping(ClaimMappingDTO claimMappingDTO) throws ClaimManagementException {
        ClaimMapping claimMapping = this.convertClaimMappingDTOToClaimMapping(claimMappingDTO);
        ClaimManagerHandler.getInstance().updateClaimMapping(claimMapping);
    }

    public void addNewClaimMapping(ClaimMappingDTO claimMappingDTO) throws ClaimManagementException {
        ClaimMapping claimMapping = this.convertClaimMappingDTOToClaimMapping(claimMappingDTO);
        ClaimManagerHandler handler = ClaimManagerHandler.getInstance();
        ClaimMapping currentMapping = handler.getClaimMapping(claimMapping.getClaim().getClaimUri());
        if (currentMapping != null) {
            throw new ClaimManagementException("Duplicate claim exist in the system. Please pick a different Claim Uri");
        }
        handler.addNewClaimMapping(claimMapping);
    }

    public void removeClaimMapping(String dialectUri, String claimUri) throws ClaimManagementException {
        ClaimManagerHandler.getInstance().removeClaimMapping(dialectUri, claimUri);
    }

    public void addNewClaimDialect(ClaimDialectDTO claimDialectDTO) throws ClaimManagementException {
        ClaimDialect claimDialect = this.convertClaimDialectDTOToClaimDialect(claimDialectDTO);
        ClaimManagerHandler.getInstance().addNewClaimDialect(claimDialect);
    }

    public void removeClaimDialect(String dialectUri) throws ClaimManagementException {
        ClaimManagerHandler.getInstance().removeClaimDialect(dialectUri);
    }

    private ClaimDialectDTO[] convertClaimDialectArrayToClaimDialectDTOArray(ClaimDialect[] claimDialects) {
        ArrayList<ClaimDialectDTO> claimDialectDTOList = new ArrayList<ClaimDialectDTO>();
        for (ClaimDialect claimDialect : claimDialects) {
            ClaimDialectDTO claimDialectDTO = this.convertClaimDialectToClaimDialectDTO(claimDialect);
            claimDialectDTOList.add(claimDialectDTO);
        }
        return claimDialectDTOList.toArray(new ClaimDialectDTO[claimDialectDTOList.size()]);
    }

    private ClaimDialectDTO convertClaimDialectToClaimDialectDTO(ClaimDialect claimDialect) {
        ClaimDialectDTO claimDialectDTO = new ClaimDialectDTO();
        claimDialectDTO.setClaimMappings(this.convertClaimMappingArrayToClaimMappingDTOArray(claimDialect.getClaimMapping()));
        claimDialectDTO.setDialectURI(claimDialect.getDialectUri());
        claimDialectDTO.setUserStore(claimDialect.getUserStore());
        return claimDialectDTO;
    }

    private ClaimMappingDTO[] convertClaimMappingArrayToClaimMappingDTOArray(ClaimMapping[] claimMappings) {
        ArrayList<ClaimMappingDTO> claimMappingDTOList = new ArrayList<ClaimMappingDTO>();
        for (ClaimMapping claimMapping : claimMappings) {
            ClaimMappingDTO claimMappingDTO = this.convertClaimMappingToClaimMappingDTO(claimMapping);
            claimMappingDTOList.add(claimMappingDTO);
        }
        return claimMappingDTOList.toArray(new ClaimMappingDTO[claimMappingDTOList.size()]);
    }

    private ClaimMapping[] convertClaimMappingDTOArrayToClaimMappingArray(ClaimMappingDTO[] claimMappingDTOs) {
        ArrayList<ClaimMapping> claimMappings = new ArrayList<ClaimMapping>();
        for (ClaimMappingDTO claimMappingDTO : claimMappingDTOs) {
            ClaimMapping claimMapping = this.convertClaimMappingDTOToClaimMapping(claimMappingDTO);
            claimMappings.add(claimMapping);
        }
        return claimMappings.toArray(new ClaimMapping[claimMappings.size()]);
    }

    private ClaimMappingDTO convertClaimMappingToClaimMappingDTO(ClaimMapping claimMapping) {
        ClaimMappingDTO claimMappingDTO = new ClaimMappingDTO();
        claimMappingDTO.setClaim(this.convertClaimToClaimDTO(claimMapping.getClaim()));
        claimMappingDTO.setMappedAttribute(claimMapping.getMappedAttribute());
        Map attributes = claimMapping.getMappedAttributes();
        if (attributes != null) {
            ClaimAttributeDTO[] attrDto = new ClaimAttributeDTO[attributes.size()];
            int i = 0;
            for (Map.Entry entry : attributes.entrySet()) {
                ClaimAttributeDTO dto = new ClaimAttributeDTO();
                dto.setAttributeName((String)entry.getValue());
                dto.setDomainName((String)entry.getKey());
                attrDto[i++] = dto;
            }
            claimMappingDTO.setMappedAttributes(attrDto);
        }
        return claimMappingDTO;
    }

    private ClaimMapping convertClaimMappingDTOToClaimMapping(ClaimMappingDTO claimMappingDTO) {
        ClaimMapping claimMapping = new ClaimMapping(this.convertClaimDTOToClaim(claimMappingDTO.getClaim()), claimMappingDTO.getMappedAttribute());
        ClaimAttributeDTO[] attributes = claimMappingDTO.getMappedAttributes();
        if (attributes != null) {
            for (ClaimAttributeDTO attribute : attributes) {
                if (attribute.getDomainName() == null) continue;
                claimMapping.setMappedAttribute(attribute.getDomainName(), attribute.getAttributeName());
            }
        }
        return claimMapping;
    }

    private ClaimDTO convertClaimToClaimDTO(Claim claim) {
        ClaimDTO claimDTO = new ClaimDTO();
        claimDTO.setClaimUri(claim.getClaimUri());
        claimDTO.setDescription(claim.getDescription());
        claimDTO.setDialectURI(claim.getDialectURI());
        claimDTO.setDisplayOrder(claim.getDisplayOrder());
        claimDTO.setDisplayTag(claim.getDisplayTag());
        claimDTO.setRegEx(claim.getRegEx());
        claimDTO.setRequired(claim.isRequired());
        claimDTO.setSupportedByDefault(claim.isSupportedByDefault());
        claimDTO.setValue(claim.getValue());
        claimDTO.setCheckedAttribute(claim.isCheckedAttribute());
        claimDTO.setReadOnly(claim.isReadOnly());
        return claimDTO;
    }

    private Claim convertClaimDTOToClaim(ClaimDTO claimDTO) {
        Claim claim = new Claim();
        claim.setSupportedByDefault(claimDTO.isSupportedByDefault());
        claim.setValue(claimDTO.getValue());
        claim.setClaimUri(claimDTO.getClaimUri());
        claim.setDescription(claimDTO.getDescription());
        claim.setDialectURI(claimDTO.getDialectURI());
        claim.setDisplayOrder(claimDTO.getDisplayOrder());
        claim.setDisplayTag(claimDTO.getDisplayTag());
        claim.setRegEx(claimDTO.getRegEx());
        claim.setRequired(claimDTO.isRequired());
        claim.setCheckedAttribute(claimDTO.isCheckedAttribute());
        claim.setReadOnly(claimDTO.isReadOnly());
        return claim;
    }

    private ClaimDialect convertClaimDialectDTOToClaimDialect(ClaimDialectDTO claimDialectDTO) {
        ClaimDialect claimDialect = new ClaimDialect();
        claimDialect.setClaimMapping(this.convertClaimMappingDTOArrayToClaimMappingArray(claimDialectDTO.getClaimMappings()));
        claimDialect.setDialectUri(claimDialectDTO.getDialectURI());
        claimDialect.setUserStore(claimDialectDTO.getUserStore());
        return claimDialect;
    }
}

