/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import waffle.windows.auth.IWindowsCredentialsHandle;

public class WindowsCredentialsHandleImpl
implements IWindowsCredentialsHandle {
    private String _principalName = null;
    private int _credentialsType = 0;
    private String _securityPackage = null;
    private Sspi.CredHandle _handle = null;
    private Sspi.TimeStamp _clientLifetime = null;

    public static IWindowsCredentialsHandle getCurrent(String securityPackage) {
        WindowsCredentialsHandleImpl handle = new WindowsCredentialsHandleImpl(null, 2, securityPackage);
        handle.initialize();
        return handle;
    }

    public WindowsCredentialsHandleImpl(String principalName, int credentialsType, String securityPackage) {
        this._principalName = principalName;
        this._credentialsType = credentialsType;
        this._securityPackage = securityPackage;
    }

    @Override
    public void initialize() {
        this._handle = new Sspi.CredHandle();
        this._clientLifetime = new Sspi.TimeStamp();
        int rc = Secur32.INSTANCE.AcquireCredentialsHandle(this._principalName, this._securityPackage, this._credentialsType, null, null, null, null, this._handle, this._clientLifetime);
        if (0 != rc) {
            throw new Win32Exception(rc);
        }
    }

    @Override
    public void dispose() {
        int rc;
        if (this._handle != null && !this._handle.isNull() && 0 != (rc = Secur32.INSTANCE.FreeCredentialsHandle(this._handle))) {
            throw new Win32Exception(rc);
        }
    }

    @Override
    public Sspi.CredHandle getHandle() {
        return this._handle;
    }
}

