/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.sun.jna.Platform;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.Netapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.awt.Desktop;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WaffleInfo {
    public Document getWaffleInfo() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("waffle");
        String version = WaffleInfo.class.getPackage().getImplementationVersion();
        if (version != null) {
            root.setAttribute("version", version);
        }
        if ((version = Platform.class.getPackage().getImplementationVersion()) != null) {
            root.setAttribute("jna", version);
        }
        if ((version = WindowUtils.class.getPackage().getImplementationVersion()) != null) {
            root.setAttribute("jna-platform", version);
        }
        doc.appendChild(root);
        root.appendChild(this.getAuthProviderInfo(doc));
        return doc;
    }

    protected Element getAuthProviderInfo(Document doc) {
        WindowsAuthProviderImpl auth = new WindowsAuthProviderImpl();
        Element node = doc.createElement("auth");
        node.setAttribute("class", auth.getClass().getName());
        Element child = doc.createElement("currentUser");
        node.appendChild(child);
        String currentUsername = WindowsAccountImpl.getCurrentUsername();
        this.addAccountInfo(doc, child, new WindowsAccountImpl(currentUsername));
        child = doc.createElement("computer");
        node.appendChild(child);
        IWindowsComputer c = auth.getCurrentComputer();
        Element value = doc.createElement("computerName");
        value.setTextContent(c.getComputerName());
        child.appendChild(value);
        value = doc.createElement("memberOf");
        value.setTextContent(c.getMemberOf());
        child.appendChild(value);
        value = doc.createElement("joinStatus");
        value.setTextContent(c.getJoinStatus());
        child.appendChild(value);
        value = doc.createElement("groups");
        for (String s : c.getGroups()) {
            Element g = doc.createElement("group");
            g.setTextContent(s);
            value.appendChild(g);
        }
        child.appendChild(value);
        if (Netapi32Util.getJoinStatus() == 3) {
            child = doc.createElement("domains");
            node.appendChild(child);
            for (IWindowsDomain domain : auth.getDomains()) {
                Element d = doc.createElement("domain");
                node.appendChild(d);
                value = doc.createElement("FQN");
                value.setTextContent(domain.getFqn());
                child.appendChild(value);
                value = doc.createElement("TrustTypeString");
                value.setTextContent(domain.getTrustTypeString());
                child.appendChild(value);
                value = doc.createElement("TrustDirectionString");
                value.setTextContent(domain.getTrustDirectionString());
                child.appendChild(value);
            }
        }
        return node;
    }

    protected void addAccountInfo(Document doc, Element node, IWindowsAccount account) {
        Element value = doc.createElement("Name");
        value.setTextContent(account.getName());
        node.appendChild(value);
        value = doc.createElement("FQN");
        value.setTextContent(account.getFqn());
        node.appendChild(value);
        value = doc.createElement("Domain");
        value.setTextContent(account.getDomain());
        node.appendChild(value);
        value = doc.createElement("SID");
        value.setTextContent(account.getSidString());
        node.appendChild(value);
    }

    public Element getLookupInfo(Document doc, String lookup) {
        WindowsAuthProviderImpl auth = new WindowsAuthProviderImpl();
        Element node = doc.createElement("lookup");
        node.setAttribute("name", lookup);
        try {
            this.addAccountInfo(doc, node, auth.lookupAccount(lookup));
        }
        catch (Win32Exception ex) {
            node.appendChild(WaffleInfo.getException(doc, ex));
        }
        return node;
    }

    public static Element getException(Document doc, Exception t) {
        Element node = doc.createElement("exception");
        node.setAttribute("class", t.getClass().getName());
        Element value = doc.createElement("message");
        if (t.getMessage() != null) {
            value.setTextContent(t.getMessage());
            node.appendChild(value);
        }
        value = doc.createElement("trace");
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        value.setTextContent(((Object)result).toString());
        node.appendChild(value);
        return node;
    }

    public static String toPrettyXML(Document doc) throws TransformerException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        return sw.toString();
    }

    public static void main(String[] args) {
        boolean show = false;
        ArrayList<String> lookup = new ArrayList<String>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-show".equals(arg)) {
                    show = true;
                    continue;
                }
                if (arg.equals("-lookup")) {
                    lookup.add(args[++i]);
                    continue;
                }
                System.err.println("Unknown Argument: " + arg);
                System.exit(1);
            }
        }
        WaffleInfo helper = new WaffleInfo();
        try {
            Document info = helper.getWaffleInfo();
            for (String name : lookup) {
                info.getDocumentElement().appendChild(helper.getLookupInfo(info, name));
            }
            String xml = WaffleInfo.toPrettyXML(info);
            if (show) {
                File f = File.createTempFile("waffle-info-", ".xml");
                Files.write((CharSequence)xml, (File)f, (Charset)Charsets.UTF_8);
                Desktop.getDesktop().open(f);
            } else {
                System.out.println(xml);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

