/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import javax.servlet.http.HttpServletRequest;
import waffle.util.Base64;
import waffle.util.NtlmMessage;
import waffle.util.SPNegoMessage;

public class AuthorizationHeader {
    private HttpServletRequest _request;

    public AuthorizationHeader(HttpServletRequest request) {
        this._request = request;
    }

    public String getHeader() {
        return this._request.getHeader("Authorization");
    }

    public boolean isNull() {
        String header = this.getHeader();
        return header == null || header.length() == 0;
    }

    public String getSecurityPackage() {
        String header = this.getHeader();
        if (header == null) {
            throw new RuntimeException("Missing Authorization: header");
        }
        int space = header.indexOf(32);
        if (space > 0) {
            return header.substring(0, space);
        }
        throw new RuntimeException("Invalid Authorization header: " + header);
    }

    public String toString() {
        return this.isNull() ? "<none>" : this.getHeader();
    }

    public String getToken() {
        return this.getHeader().substring(this.getSecurityPackage().length() + 1);
    }

    public byte[] getTokenBytes() {
        return Base64.decode(this.getToken());
    }

    public boolean isNtlmType1Message() {
        if (this.isNull()) {
            return false;
        }
        byte[] tokenBytes = this.getTokenBytes();
        if (!NtlmMessage.isNtlmMessage(tokenBytes)) {
            return false;
        }
        return 1 == NtlmMessage.getMessageType(tokenBytes);
    }

    public boolean isSPNegoMessage() {
        if (this.isNull()) {
            return false;
        }
        byte[] tokenBytes = this.getTokenBytes();
        return SPNegoMessage.isSPNegoMessage(tokenBytes);
    }

    public boolean isNtlmType1PostAuthorizationHeader() {
        if (!this._request.getMethod().equals("POST") && !this._request.getMethod().equals("PUT")) {
            return false;
        }
        if (this._request.getContentLength() != 0) {
            return false;
        }
        return this.isNtlmType1Message() || this.isSPNegoMessage();
    }
}

