/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateSecurityFilterProvider
implements SecurityFilterProvider {
    private Logger _log = LoggerFactory.getLogger(NegotiateSecurityFilterProvider.class);
    private List<String> _protocols = new ArrayList<String>();
    private IWindowsAuthProvider _auth = null;

    public NegotiateSecurityFilterProvider(IWindowsAuthProvider auth) {
        this._auth = auth;
        this._protocols.add("Negotiate");
        this._protocols.add("NTLM");
    }

    public List<String> getProtocols() {
        return this._protocols;
    }

    public void setProtocols(List<String> protocols) {
        this._protocols = protocols;
    }

    @Override
    public void sendUnauthorized(HttpServletResponse response) {
        Iterator<String> protocolsIterator = this._protocols.iterator();
        while (protocolsIterator.hasNext()) {
            response.addHeader("WWW-Authenticate", protocolsIterator.next());
        }
    }

    @Override
    public boolean isPrincipalException(HttpServletRequest request) {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + ntlmPost);
        return ntlmPost;
    }

    @Override
    public IWindowsIdentity doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        String connectionId = NtlmServletRequest.getConnectionId(request);
        String securityPackage = authorizationHeader.getSecurityPackage();
        this._log.debug("security package: " + securityPackage + ", connection id: " + connectionId);
        if (ntlmPost) {
            this._auth.resetSecurityToken(connectionId);
        }
        byte[] tokenBuffer = authorizationHeader.getTokenBytes();
        this._log.debug("token buffer: " + tokenBuffer.length + " byte(s)");
        IWindowsSecurityContext securityContext = this._auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
        byte[] continueTokenBytes = securityContext.getToken();
        if (continueTokenBytes != null && continueTokenBytes.length > 0) {
            String continueToken = new String(Base64.encode(continueTokenBytes));
            this._log.debug("continue token: " + continueToken);
            response.addHeader("WWW-Authenticate", securityPackage + " " + continueToken);
        }
        this._log.debug("continue required: " + securityContext.isContinue());
        if (securityContext.isContinue() || ntlmPost) {
            response.setHeader("Connection", "keep-alive");
            response.setStatus(401);
            response.flushBuffer();
            return null;
        }
        IWindowsIdentity identity = securityContext.getIdentity();
        securityContext.dispose();
        return identity;
    }

    @Override
    public boolean isSecurityPackageSupported(String securityPackage) {
        for (String protocol : this._protocols) {
            if (!protocol.equalsIgnoreCase(securityPackage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initParameter(String parameterName, String parameterValue) {
        if (parameterName.equals("protocols")) {
            String[] protocolNames;
            this._protocols = new ArrayList<String>();
            for (String protocolName : protocolNames = parameterValue.split("\\s+")) {
                if ((protocolName = protocolName.trim()).length() <= 0) continue;
                this._log.debug("init protocol: " + protocolName);
                if (protocolName.equals("Negotiate") || protocolName.equals("NTLM")) {
                    this._protocols.add(protocolName);
                    continue;
                }
                this._log.error("unsupported protocol: " + protocolName);
                throw new RuntimeException("Unsupported protocol: " + protocolName);
            }
        } else {
            throw new InvalidParameterException(parameterName);
        }
    }
}

