/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.AutoDisposableWindowsPrincipal;
import waffle.servlet.NegotiateRequestWrapper;
import waffle.servlet.WindowsPrincipal;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class NegotiateSecurityFilter
implements Filter {
    private Logger _log = LoggerFactory.getLogger(NegotiateSecurityFilter.class);
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private SecurityFilterProviderCollection _providers = null;
    private IWindowsAuthProvider _auth;
    private boolean _allowGuestLogin = true;
    private boolean _impersonate = false;
    private static final String PRINCIPAL_SESSION_KEY = NegotiateSecurityFilter.class.getName() + ".PRINCIPAL";

    public NegotiateSecurityFilter() {
        this._log.debug("[waffle.servlet.NegotiateSecurityFilter] loaded");
    }

    public void destroy() {
        this._log.info("[waffle.servlet.NegotiateSecurityFilter] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)sreq;
        HttpServletResponse response = (HttpServletResponse)sres;
        this._log.debug(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength());
        if (this.doFilterPrincipal(request, response, chain)) {
            return;
        }
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        if (!authorizationHeader.isNull()) {
            IWindowsIdentity windowsIdentity = null;
            try {
                windowsIdentity = this._providers.doFilter(request, response);
                if (windowsIdentity == null) {
                    return;
                }
            }
            catch (Exception e) {
                this._log.warn("error logging in user: " + e.getMessage());
                this.sendUnauthorized(response, true);
                return;
            }
            IWindowsImpersonationContext ctx = null;
            try {
                if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
                    this._log.warn("guest login disabled: " + windowsIdentity.getFqn());
                    this.sendUnauthorized(response, true);
                    return;
                }
                this._log.debug("logged in user: " + windowsIdentity.getFqn() + " (" + windowsIdentity.getSidString() + ")");
                HttpSession session = request.getSession(true);
                if (session == null) {
                    throw new ServletException("Expected HttpSession");
                }
                Subject subject = (Subject)session.getAttribute("javax.security.auth.subject");
                if (subject == null) {
                    subject = new Subject();
                }
                WindowsPrincipal windowsPrincipal = null;
                windowsPrincipal = this._impersonate ? new AutoDisposableWindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat) : new WindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat);
                this._log.debug("roles: " + windowsPrincipal.getRolesString());
                subject.getPrincipals().add(windowsPrincipal);
                session.setAttribute("javax.security.auth.subject", (Object)subject);
                this._log.info("successfully logged in user: " + windowsIdentity.getFqn());
                request.getSession().setAttribute(PRINCIPAL_SESSION_KEY, (Object)windowsPrincipal);
                NegotiateRequestWrapper requestWrapper = new NegotiateRequestWrapper(request, windowsPrincipal);
                if (this._impersonate) {
                    this._log.debug("impersonating user");
                    ctx = windowsIdentity.impersonate();
                }
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
            }
            finally {
                if (this._impersonate && ctx != null) {
                    this._log.debug("terminating impersonation");
                    ctx.revertToSelf();
                } else {
                    windowsIdentity.dispose();
                }
            }
            return;
        }
        this._log.debug("authorization required");
        this.sendUnauthorized(response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterPrincipal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        Principal principal = request.getUserPrincipal();
        if (principal == null && (session = request.getSession(false)) != null) {
            principal = (Principal)session.getAttribute(PRINCIPAL_SESSION_KEY);
        }
        if (principal == null) {
            return false;
        }
        if (this._providers.isPrincipalException(request)) {
            return false;
        }
        if (principal instanceof WindowsPrincipal) {
            this._log.debug("previously authenticated Windows user: " + principal.getName());
            WindowsPrincipal windowsPrincipal = (WindowsPrincipal)principal;
            if (this._impersonate && windowsPrincipal.getIdentity() == null) {
                return false;
            }
            NegotiateRequestWrapper requestWrapper = new NegotiateRequestWrapper(request, windowsPrincipal);
            IWindowsImpersonationContext ctx = null;
            if (this._impersonate) {
                this._log.debug("re-impersonating user");
                ctx = windowsPrincipal.getIdentity().impersonate();
            }
            try {
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
            }
            finally {
                if (this._impersonate && ctx != null) {
                    this._log.debug("terminating impersonation");
                    ctx.revertToSelf();
                }
            }
        } else {
            this._log.debug("previously authenticated user: " + principal.getName());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        return true;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        HashMap<String, String> implParameters = new HashMap<String, String>();
        String authProvider = null;
        String[] providerNames = null;
        if (filterConfig != null) {
            Enumeration parameterNames = filterConfig.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = filterConfig.getInitParameter(parameterName);
                this._log.debug(parameterName + "=" + parameterValue);
                if (parameterName.equals("principalFormat")) {
                    this._principalFormat = PrincipalFormat.valueOf(parameterValue);
                    continue;
                }
                if (parameterName.equals("roleFormat")) {
                    this._roleFormat = PrincipalFormat.valueOf(parameterValue);
                    continue;
                }
                if (parameterName.equals("allowGuestLogin")) {
                    this._allowGuestLogin = Boolean.parseBoolean(parameterValue);
                    continue;
                }
                if (parameterName.equals("impersonate")) {
                    this._impersonate = Boolean.parseBoolean(parameterValue);
                    continue;
                }
                if (parameterName.equals("securityFilterProviders")) {
                    providerNames = parameterValue.split("\\s+");
                    continue;
                }
                if (parameterName.equals("authProvider")) {
                    authProvider = parameterValue;
                    continue;
                }
                implParameters.put(parameterName, parameterValue);
            }
        }
        if (authProvider != null) {
            try {
                this._auth = (IWindowsAuthProvider)Class.forName(authProvider).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                this._log.error("error loading '" + authProvider + "': " + e.getMessage());
                throw new ServletException((Throwable)e);
            }
        }
        if (this._auth == null) {
            this._auth = new WindowsAuthProviderImpl();
        }
        if (providerNames != null) {
            this._providers = new SecurityFilterProviderCollection(providerNames, this._auth);
        }
        if (this._providers == null) {
            this._log.debug("initializing default security filter providers");
            this._providers = new SecurityFilterProviderCollection(this._auth);
        }
        for (Map.Entry implParameter : implParameters.entrySet()) {
            String[] classAndParameter = ((String)implParameter.getKey()).split("/", 2);
            if (classAndParameter.length == 2) {
                try {
                    this._log.debug("setting " + classAndParameter[0] + ", " + classAndParameter[1] + "=" + (String)implParameter.getValue());
                    SecurityFilterProvider provider = this._providers.getByClassName(classAndParameter[0]);
                    provider.initParameter(classAndParameter[1], (String)implParameter.getValue());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this._log.error("invalid class: " + classAndParameter[0] + " in " + (String)implParameter.getKey());
                    throw new ServletException((Throwable)e);
                }
                catch (Exception e) {
                    this._log.error(classAndParameter[0] + ": error setting '" + classAndParameter[1] + "': " + e.getMessage());
                    throw new ServletException((Throwable)e);
                }
            }
            this._log.error("Invalid parameter: " + (String)implParameter.getKey());
            throw new ServletException("Invalid parameter: " + (String)implParameter.getKey());
        }
        this._log.info("[waffle.servlet.NegotiateSecurityFilter] started");
    }

    public void setPrincipalFormat(String format) {
        this._principalFormat = PrincipalFormat.valueOf(format);
        this._log.info("principal format: " + (Object)((Object)this._principalFormat));
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setRoleFormat(String format) {
        this._roleFormat = PrincipalFormat.valueOf(format);
        this._log.info("role format: " + (Object)((Object)this._roleFormat));
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    private void sendUnauthorized(HttpServletResponse response, boolean close) {
        try {
            this._providers.sendUnauthorized(response);
            if (close) {
                response.setHeader("Connection", "close");
            } else {
                response.setHeader("Connection", "keep-alive");
            }
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this._auth = provider;
    }

    public boolean isAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setImpersonate(boolean impersonate) {
        this._impersonate = impersonate;
    }

    public boolean isImpersonate() {
        return this._impersonate;
    }

    public SecurityFilterProviderCollection getProviders() {
        return this._providers;
    }
}

