/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.slf4j.Logger;
import waffle.apache.GenericWindowsPrincipal;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

abstract class WaffleAuthenticatorBase
extends AuthenticatorBase {
    protected String _info = null;
    protected Logger _log = null;
    protected PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    protected PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    protected boolean _allowGuestLogin = true;
    protected IWindowsAuthProvider _auth = new WindowsAuthProviderImpl();

    WaffleAuthenticatorBase() {
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this._auth = provider;
    }

    public String getInfo() {
        return this._info;
    }

    public void setPrincipalFormat(String format) {
        this._principalFormat = PrincipalFormat.valueOf(format);
        this._log.debug("principal format: " + (Object)((Object)this._principalFormat));
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setRoleFormat(String format) {
        this._roleFormat = PrincipalFormat.valueOf(format);
        this._log.debug("role format: " + (Object)((Object)this._roleFormat));
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    public boolean isAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this._allowGuestLogin = value;
    }

    protected void sendUnauthorized(HttpServletResponse response) {
        try {
            response.addHeader("WWW-Authenticate", "Negotiate");
            response.addHeader("WWW-Authenticate", "NTLM");
            response.setHeader("Connection", "close");
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendError(HttpServletResponse response, int code) {
        try {
            response.sendError(code);
        }
        catch (IOException e) {
            this._log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    protected String getAuthMethod() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal doLogin(Request request, String username, String password) throws ServletException {
        this._log.debug("logging in: " + username);
        IWindowsIdentity windowsIdentity = null;
        try {
            windowsIdentity = this._auth.logonUser(username, password);
        }
        catch (Exception e) {
            this._log.error(e.getMessage());
            return super.doLogin(request, username, password);
        }
        if (!this._allowGuestLogin && windowsIdentity.isGuest()) {
            this._log.warn("guest login disabled: " + windowsIdentity.getFqn());
            return super.doLogin(request, username, password);
        }
        try {
            this._log.debug("successfully logged in " + username + " (" + windowsIdentity.getSidString() + ")");
            GenericWindowsPrincipal windowsPrincipal = new GenericWindowsPrincipal(windowsIdentity, this._principalFormat, this._roleFormat);
            this._log.debug("roles: " + windowsPrincipal.getRolesString());
            GenericWindowsPrincipal genericWindowsPrincipal = windowsPrincipal;
            return genericWindowsPrincipal;
        }
        finally {
            windowsIdentity.dispose();
        }
    }
}

