/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.webapp;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.statistics.webapp.ComputeData;
import org.wso2.carbon.statistics.webapp.data.StatisticData;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RequestIntercepterValve
extends ValveBase {
    public RequestIntercepterValve() {
        super(true);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        this.getNext().invoke(request, response);
        if (CarbonUtils.isWorkerNode()) {
            return;
        }
        Long responseTime = System.currentTimeMillis() - startTime;
        String requestURI = request.getRequestURI().trim();
        String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)requestURI);
        StatisticData statisticData = new StatisticData();
        int firstDigit = Integer.parseInt(Integer.toString(response.getStatus()).substring(0, 1));
        statisticData.setRequstCount(1);
        if (firstDigit == 2 || firstDigit == 3) {
            statisticData.setResponseCount(1);
            statisticData.setFaultCount(0);
        } else if (firstDigit == 4 || firstDigit == 5) {
            statisticData.setResponseCount(0);
            statisticData.setFaultCount(1);
        }
        String[] requestedUriParts = requestURI.split("/");
        if (requestedUriParts == null) {
            return;
        }
        if (requestedUriParts.length >= 5 && requestURI.startsWith("/t/")) {
            statisticData.setWebappName(requestedUriParts[4]);
            statisticData.setTenantName(requestedUriParts[2]);
        } else if (requestedUriParts.length >= 2 && !requestURI.startsWith("/t/")) {
            statisticData.setWebappName(requestedUriParts[1]);
            statisticData.setTenantName("carbon.super");
        } else {
            return;
        }
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        statisticData.setTenantId(tenantID);
        statisticData.setResponseTime(responseTime.longValue());
        ComputeData cd = new ComputeData();
        cd.setRequestData(statisticData);
    }
}

