/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.webapp;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.statistics.webapp.data.StatisticData;

public class ComputeData {
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<String, StatisticData>> map = new ConcurrentHashMap();

    public void setRequestData(StatisticData requestData) {
        if (map.containsKey(requestData.getTenantId())) {
            ConcurrentHashMap<String, StatisticData> m = map.get(requestData.getTenantId());
            if (m.containsKey(requestData.getWebappName())) {
                StatisticData st = this.updateRequestsData(requestData, m.get(requestData.getWebappName()));
                m.put(requestData.getWebappName(), st);
                map.put(requestData.getTenantId(), m);
            } else {
                m.put(requestData.getWebappName(), requestData);
                map.put(requestData.getTenantId(), m);
            }
        } else {
            ConcurrentHashMap<String, StatisticData> m = new ConcurrentHashMap<String, StatisticData>();
            m.put(requestData.getWebappName(), requestData);
            map.put(requestData.getTenantId(), m);
        }
    }

    private StatisticData updateRequestsData(StatisticData requestStatisticData, StatisticData storedStatisticData) {
        int reqCount = storedStatisticData.getRequstCount() + 1;
        int resCount = storedStatisticData.getResponseCount() + requestStatisticData.getResponseCount();
        int fauCount = storedStatisticData.getFaultCount() + requestStatisticData.getFaultCount();
        double averageResponseTime = (storedStatisticData.getAverageResponseTime() * (double)(reqCount - 1) + requestStatisticData.getResponseTime()) / (double)reqCount;
        if (storedStatisticData.getMaximumResponseTime() < requestStatisticData.getResponseTime()) {
            storedStatisticData.setMaximumResponseTime(requestStatisticData.getResponseTime());
        }
        if (storedStatisticData.getMinimumresponseTime() > requestStatisticData.getResponseTime()) {
            storedStatisticData.setMinimumresponseTime(requestStatisticData.getResponseTime());
        }
        storedStatisticData.setRequstCount(reqCount);
        storedStatisticData.setResponseCount(resCount);
        storedStatisticData.setFaultCount(fauCount);
        storedStatisticData.setAverageResponseTime(averageResponseTime);
        return storedStatisticData;
    }
}

