/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.services.util;

import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.statistics.services.util.Metric;
import org.wso2.carbon.utils.NetworkUtils;

public class SystemStatistics {
    private String serverName;
    private String serverStartTime;
    private String systemUpTime;
    private int totalRequestCount;
    private int totalResponseCount;
    private int totalFaultCount;
    private int currentInvocationRequestCount;
    private int currentInvocationResponseCount;
    private int currentInvocationFaultCount;
    private int services;
    private Metric usedMemory;
    private Metric totalMemory;
    private double avgResponseTime;
    private long currentInvocationResponseTime;
    private long minResponseTime;
    private long maxResponseTime;
    private String wso2wsasVersion;
    private SimpleDateFormat dateFormatter;
    private String javaVersion;
    private static final long GB_IN_BYTES = 0x40000000L;
    private static final long MB_IN_BYTES = 0x100000L;
    private static final long KB_IN_BYTES = 1024L;
    private static final int SECONDS_PER_DAY = 86400;
    private SystemStatisticsUtil statService;

    public SystemStatistics(AxisConfiguration configuration) throws AxisFault {
        try {
            this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
            this.statService = new SystemStatisticsUtil();
            this.javaVersion = System.getProperty("java.version");
            this.update(configuration);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public SystemStatistics(MessageContext messageContext) throws AxisFault {
        try {
            this.statService = new SystemStatisticsUtil();
            this.javaVersion = System.getProperty("java.version");
            this.update(messageContext);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public void update(AxisConfiguration axisConfig) throws AxisFault {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Parameter systemStartTime = axisConfig.getParameter("wso2carbon.server.start.time");
        long startTime = 0L;
        if (systemStartTime != null) {
            startTime = Long.parseLong((String)systemStartTime.getValue());
        }
        Date stTime = new Date(startTime);
        if (tenantId == -1234) {
            this.serverStartTime = this.dateFormatter.format(stTime);
            this.systemUpTime = this.getTime((System.currentTimeMillis() - startTime) / 1000L);
        }
        try {
            this.totalRequestCount = this.statService.getTotalSystemRequestCount(axisConfig);
            this.totalResponseCount = this.statService.getSystemResponseCount(axisConfig);
            this.totalFaultCount = this.statService.getSystemFaultCount(axisConfig);
            this.avgResponseTime = this.statService.getAvgSystemResponseTime(axisConfig);
            this.maxResponseTime = this.statService.getMaxSystemResponseTime(axisConfig);
            this.minResponseTime = this.statService.getMinSystemResponseTime(axisConfig);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        Runtime runtime = Runtime.getRuntime();
        if (tenantId == -1234) {
            this.usedMemory = this.formatMemoryValue(runtime.totalMemory() - runtime.freeMemory());
            this.totalMemory = this.formatMemoryValue(runtime.totalMemory());
        }
        this.wso2wsasVersion = ServerConfiguration.getInstance().getFirstProperty("Version");
        int activeServices = 0;
        for (AxisService axisService : axisConfig.getServices().values()) {
            AxisServiceGroup asGroup = (AxisServiceGroup)axisService.getParent();
            if (!axisService.isActive() || axisService.isClientSide() || SystemFilter.isFilteredOutService((AxisServiceGroup)asGroup)) continue;
            ++activeServices;
        }
        this.services = activeServices;
        try {
            if (tenantId == -1234) {
                this.serverName = NetworkUtils.getLocalHostname();
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void update(MessageContext messageContext) throws AxisFault {
        try {
            this.currentInvocationResponseTime = this.statService.getCurrentSystemResponseTime(messageContext);
            this.currentInvocationResponseCount = this.statService.getCurrentSystemResponseCount(messageContext);
            this.currentInvocationRequestCount = this.statService.getCurrentSystemRequestCount(messageContext);
            this.currentInvocationFaultCount = this.statService.getCurrentSystemFaultCount(messageContext);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public int getCurrentInvocationRequestCount() {
        return this.currentInvocationRequestCount;
    }

    public void setCurrentInvocationRequestCount(int currentInvocationRequestCount) {
        this.currentInvocationRequestCount = currentInvocationRequestCount;
    }

    public int getCurrentInvocationResponseCount() {
        return this.currentInvocationResponseCount;
    }

    public void setCurrentInvocationResponseCount(int currentInvocationResponseCount) {
        this.currentInvocationResponseCount = currentInvocationResponseCount;
    }

    public int getCurrentInvocationFaultCount() {
        return this.currentInvocationFaultCount;
    }

    public void setCurrentInvocationFaultCount(int currentInvocationFaultCount) {
        this.currentInvocationFaultCount = currentInvocationFaultCount;
    }

    public long getCurrentInvocationResponseTime() {
        return this.currentInvocationResponseTime;
    }

    public void setCurrentInvocationResponseTime(long currentInvocationResponseTime) {
        this.currentInvocationResponseTime = currentInvocationResponseTime;
    }

    public SystemStatisticsUtil getStatService() {
        return this.statService;
    }

    public void setStatService(SystemStatisticsUtil statService) {
        this.statService = statService;
    }

    public String getSystemUpTime() {
        return this.systemUpTime;
    }

    public String getServerStartTime() {
        return this.serverStartTime;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public int getServices() {
        return this.services;
    }

    public Metric getUsedMemory() {
        return this.usedMemory;
    }

    public Metric getTotalMemory() {
        return this.totalMemory;
    }

    public int getTotalFaultCount() {
        return this.totalFaultCount;
    }

    public int getTotalResponseCount() {
        return this.totalResponseCount;
    }

    private Metric formatMemoryValue(double value) {
        double tempVal = value;
        String unit = "bytes";
        if (value > 0.0) {
            double d;
            tempVal = value / 1.073741824E9;
            if (d >= 1.0) {
                tempVal = this.round(tempVal, 2);
                unit = "GB";
            } else {
                double d2;
                tempVal = value / 1048576.0;
                if (d2 >= 1.0) {
                    tempVal = this.round(tempVal, 2);
                    unit = " MB";
                } else {
                    double d3;
                    tempVal = value / 1024.0;
                    if (d3 >= 1.0) {
                        tempVal = this.round(tempVal, 2);
                        unit = " KB";
                    }
                }
            }
        }
        return new Metric(tempVal, unit);
    }

    private double round(double value, int numOfDecimalPlaces) {
        long val = 1L;
        for (int i = 1; i <= numOfDecimalPlaces; ++i) {
            val *= 10L;
        }
        return (double)Math.round(value * (double)val) / (double)val;
    }

    private String getTime(long timeInSeconds) {
        long days = timeInSeconds / 86400L;
        long hours = (timeInSeconds -= days * 86400L) / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        return days + " day(s) " + hours + " hr(s) " + minutes + " min(s) " + seconds + " sec(s)";
    }

    public double getAvgResponseTime() {
        return this.avgResponseTime;
    }

    public long getMinResponseTime() {
        return this.minResponseTime;
    }

    public long getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public String getWso2wsasVersion() {
        return this.wso2wsasVersion;
    }

    public void setWso2wsasVersion(String wso2wsasVersion) {
        this.wso2wsasVersion = wso2wsasVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }
}

