/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.services;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.statistics.internal.ResponseTimeProcessor;
import org.wso2.carbon.statistics.services.util.OperationStatistics;
import org.wso2.carbon.statistics.services.util.ServiceStatistics;
import org.wso2.carbon.statistics.services.util.SystemStatistics;

public class SystemStatisticsUtil {
    public SystemStatistics getSystemStatistics(MessageContext context) throws AxisFault {
        SystemStatistics systemStatistics = new SystemStatistics(context);
        return systemStatistics;
    }

    public SystemStatistics getSystemStatistics(AxisConfiguration axisConfiguration) throws AxisFault {
        SystemStatistics systemStatistics = new SystemStatistics(axisConfiguration);
        return systemStatistics;
    }

    public ServiceStatistics getServiceStatistics(AxisService axisService) throws AxisFault {
        ServiceStatistics serviceStatistics = new ServiceStatistics();
        serviceStatistics.setAvgResponseTime(this.getAvgServiceResponseTime(axisService));
        serviceStatistics.setTotalFaultCount(this.getServiceFaultCount(axisService));
        serviceStatistics.setMaxResponseTime(this.getMaxServiceResponseTime(axisService));
        serviceStatistics.setMinResponseTime(this.getMinServiceResponseTime(axisService));
        serviceStatistics.setTotalRequestCount(this.getServiceRequestCount(axisService));
        serviceStatistics.setTotalResponseCount(this.getServiceResponseCount(axisService));
        return serviceStatistics;
    }

    public OperationStatistics getOperationStatistics(AxisOperation axisOp) throws AxisFault {
        OperationStatistics operationStatistics = new OperationStatistics();
        operationStatistics.setAvgResponseTime(this.getAvgOperationResponseTime(axisOp));
        operationStatistics.setTotalFaultCount(this.getOperationFaultCount(axisOp));
        operationStatistics.setMaxResponseTime(this.getMaxOperationResponseTime(axisOp));
        operationStatistics.setMinResponseTime(this.getMinOperationResponseTime(axisOp));
        operationStatistics.setTotalRequestCount(this.getOperationRequestCount(axisOp));
        operationStatistics.setTotalResponseCount(this.getOperationResponseCount(axisOp));
        return operationStatistics;
    }

    public int getTotalSystemRequestCount(AxisConfiguration axisConfig) throws AxisFault {
        return this.getSystemStatisticsCount(axisConfig, "wso2statistics.GlobalRequestCounter");
    }

    public int getSystemFaultCount(AxisConfiguration axisConfig) throws AxisFault {
        return this.getSystemStatisticsCount(axisConfig, "wso2statistics.GlobalFaultCounter");
    }

    public int getSystemResponseCount(AxisConfiguration axisConfig) throws AxisFault {
        return this.getSystemStatisticsCount(axisConfig, "wso2statistics.GlobalResponseCounter");
    }

    private int getSystemStatisticsCount(AxisConfiguration axisConfig, String parameterName) {
        Parameter globalCounter = axisConfig.getParameter(parameterName);
        return ((AtomicInteger)globalCounter.getValue()).get();
    }

    private long getResponseTime(AxisService axisService) {
        Object value;
        Parameter responseTimeParameter = axisService.getParameter("wso2statistics.service.response.time");
        if (responseTimeParameter != null && (value = responseTimeParameter.getValue()) instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    private long getResponseTime(AxisOperation axisOp) {
        Object value;
        Parameter responseTimeParameter = axisOp.getParameter("wso2statistics.operation.response.time");
        if (responseTimeParameter != null && (value = responseTimeParameter.getValue()) instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    public double getAvgSystemResponseTime(AxisConfiguration axisConfig) {
        Object value;
        Parameter processor = axisConfig.getParameter("wso2statistics.ResponseTimeProcessor");
        if (processor != null && (value = processor.getValue()) instanceof ResponseTimeProcessor) {
            return ((ResponseTimeProcessor)value).getAvgResponseTime();
        }
        return 0.0;
    }

    public long getMaxSystemResponseTime(AxisConfiguration axisConfig) {
        Object value;
        Parameter processor = axisConfig.getParameter("wso2statistics.ResponseTimeProcessor");
        if (processor != null && (value = processor.getValue()) instanceof ResponseTimeProcessor) {
            return ((ResponseTimeProcessor)value).getMaxResponseTime();
        }
        return 0L;
    }

    public long getMinSystemResponseTime(AxisConfiguration axisConfig) {
        Object value;
        Parameter processor = axisConfig.getParameter("wso2statistics.ResponseTimeProcessor");
        if (processor != null && (value = processor.getValue()) instanceof ResponseTimeProcessor) {
            return ((ResponseTimeProcessor)value).getMinResponseTime();
        }
        return 0L;
    }

    public int getServiceRequestCount(AxisService axisService) throws AxisFault {
        int count = 0;
        Iterator opIter = axisService.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOp = (AxisOperation)opIter.next();
            Parameter parameter = axisOp.getParameter("wso2statistics.InOperationCounter");
            if (parameter == null) continue;
            count += ((AtomicInteger)parameter.getValue()).get();
        }
        return count;
    }

    public int getServiceFaultCount(AxisService axisService) throws AxisFault {
        int count = 0;
        Iterator opIter = axisService.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOp = (AxisOperation)opIter.next();
            Parameter parameter = axisOp.getParameter("wso2statistics.OperationFaultCounter");
            if (parameter == null) continue;
            count += ((AtomicInteger)parameter.getValue()).get();
        }
        return count;
    }

    public int getServiceResponseCount(AxisService axisService) throws AxisFault {
        int count = 0;
        Iterator opIter = axisService.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOp = (AxisOperation)opIter.next();
            Parameter parameter = axisOp.getParameter("wso2statistics.OutOperationCounter");
            if (parameter == null) continue;
            count += ((AtomicInteger)parameter.getValue()).get();
        }
        return count;
    }

    public long getMaxServiceResponseTime(AxisService axisService) throws AxisFault {
        long max = 0L;
        Parameter parameter = axisService.getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            max = proc.getMaxResponseTime();
        }
        return max;
    }

    public long getMinServiceResponseTime(AxisService axisService) throws AxisFault {
        long min = 0L;
        Parameter parameter = axisService.getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            min = proc.getMinResponseTime();
        }
        if (min == -1L) {
            min = 0L;
        }
        return min;
    }

    public double getAvgServiceResponseTime(AxisService axisService) throws AxisFault {
        double avg = 0.0;
        Parameter parameter = axisService.getParameter("wso2statistics.ServiceResponseTimeProc");
        if (parameter != null) {
            ResponseTimeProcessor proc = (ResponseTimeProcessor)parameter.getValue();
            avg = proc.getAvgResponseTime();
        }
        return avg;
    }

    public int getOperationRequestCount(AxisOperation axisOperation) throws AxisFault {
        Parameter parameter = axisOperation.getParameter("wso2statistics.InOperationCounter");
        if (parameter != null) {
            return ((AtomicInteger)parameter.getValue()).get();
        }
        return 0;
    }

    public int getOperationFaultCount(AxisOperation axisOperation) throws AxisFault {
        Parameter parameter = axisOperation.getParameter("wso2statistics.OperationFaultCounter");
        if (parameter != null) {
            return ((AtomicInteger)parameter.getValue()).get();
        }
        return 0;
    }

    public int getOperationResponseCount(AxisOperation axisOperation) throws AxisFault {
        Parameter parameter = axisOperation.getParameter("wso2statistics.OutOperationCounter");
        if (parameter != null) {
            return ((AtomicInteger)parameter.getValue()).get();
        }
        return 0;
    }

    public long getMaxOperationResponseTime(AxisOperation axisOperation) throws AxisFault {
        long max = 0L;
        Parameter parameter = axisOperation.getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            max = ((ResponseTimeProcessor)parameter.getValue()).getMaxResponseTime();
        }
        return max;
    }

    public long getMinOperationResponseTime(AxisOperation axisOperation) throws AxisFault {
        long min = 0L;
        Parameter parameter = axisOperation.getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            min = ((ResponseTimeProcessor)parameter.getValue()).getMinResponseTime();
        }
        if (min == -1L) {
            min = 0L;
        }
        return min;
    }

    public double getAvgOperationResponseTime(AxisOperation axisOperation) throws AxisFault {
        double avg = 0.0;
        Parameter parameter = axisOperation.getParameter("wso2statistics.OperationResponseTimeProc");
        if (parameter != null) {
            avg = ((ResponseTimeProcessor)parameter.getValue()).getAvgResponseTime();
        }
        return avg;
    }

    public int getCurrentSystemResponseCount(MessageContext messageContext) {
        Object value;
        Object currentSystemResponseCount = messageContext.getProperty("wso2statistics.GlobalCurrentResponseCounter");
        if (currentSystemResponseCount != null && (value = currentSystemResponseCount) instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public long getCurrentSystemResponseTime(MessageContext messageContext) {
        Object value;
        Object currentSystemResponseTime = messageContext.getProperty("wso2statistics.global.invocation.response.time");
        if (currentSystemResponseTime != null && (value = currentSystemResponseTime) instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    public int getCurrentSystemRequestCount(MessageContext messageContext) {
        Object value;
        Object currentSystemRequestCount = messageContext.getProperty("wso2statistics.GlobalCurrentRequestCounter");
        if (currentSystemRequestCount != null && (value = currentSystemRequestCount) instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public int getCurrentSystemFaultCount(MessageContext messageContext) {
        Object value;
        Object currentSystemFaultCount = messageContext.getProperty("wso2statistics.GlobalCurrentFaultCounter");
        if (currentSystemFaultCount != null && (value = currentSystemFaultCount) instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }
}

