/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.services;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.statistics.services.StatisticsAdminMBean;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.statistics.services.util.OperationStatistics;
import org.wso2.carbon.statistics.services.util.ServiceStatistics;
import org.wso2.carbon.statistics.services.util.SystemStatistics;
import org.wso2.carbon.statistics.webapp.ComputeData;
import org.wso2.carbon.statistics.webapp.data.StatisticData;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class StatisticsAdmin
extends AbstractAdmin
implements StatisticsAdminMBean {
    private SystemStatisticsUtil sysStatsUtil = new SystemStatisticsUtil();
    private static Log log = LogFactory.getLog(StatisticsAdmin.class);

    public SystemStatistics getSystemStatistics() throws AxisFault {
        return this.sysStatsUtil.getSystemStatistics(this.getAxisConfig());
    }

    public ServiceStatistics getServiceStatistics(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getServiceStatistics(this.getAxisService(serviceName));
    }

    public OperationStatistics getOperationStatistics(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getOperationStatistics(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public int getSystemRequestCount() throws AxisFault {
        return this.sysStatsUtil.getTotalSystemRequestCount(this.getAxisConfig());
    }

    @Override
    public int getSystemFaultCount() throws AxisFault {
        return this.sysStatsUtil.getSystemFaultCount(this.getAxisConfig());
    }

    @Override
    public int getSystemResponseCount() throws AxisFault {
        return this.sysStatsUtil.getSystemResponseCount(this.getAxisConfig());
    }

    @Override
    public double getAvgSystemResponseTime() {
        return this.sysStatsUtil.getAvgSystemResponseTime(this.getAxisConfig());
    }

    @Override
    public long getMaxSystemResponseTime() {
        return this.sysStatsUtil.getMaxSystemResponseTime(this.getAxisConfig());
    }

    @Override
    public long getMinSystemResponseTime() {
        return this.sysStatsUtil.getMinSystemResponseTime(this.getAxisConfig());
    }

    @Override
    public int getServiceRequestCount(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getServiceRequestCount(this.getAxisService(serviceName));
    }

    @Override
    public int getServiceFaultCount(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getServiceFaultCount(this.getAxisService(serviceName));
    }

    @Override
    public int getServiceResponseCount(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getServiceResponseCount(this.getAxisService(serviceName));
    }

    @Override
    public long getMaxServiceResponseTime(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getMaxServiceResponseTime(this.getAxisService(serviceName));
    }

    @Override
    public long getMinServiceResponseTime(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getMinServiceResponseTime(this.getAxisService(serviceName));
    }

    @Override
    public double getAvgServiceResponseTime(String serviceName) throws AxisFault {
        return this.sysStatsUtil.getAvgServiceResponseTime(this.getAxisService(serviceName));
    }

    @Override
    public int getOperationRequestCount(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getOperationRequestCount(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public int getOperationFaultCount(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getOperationFaultCount(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public int getOperationResponseCount(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getOperationResponseCount(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public long getMaxOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getMaxOperationResponseTime(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public long getMinOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getMinOperationResponseTime(this.getAxisOperation(serviceName, operationName));
    }

    @Override
    public double getAvgOperationResponseTime(String serviceName, String operationName) throws AxisFault {
        return this.sysStatsUtil.getAvgOperationResponseTime(this.getAxisOperation(serviceName, operationName));
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        super.setConfigurationContext(configurationContext);
    }

    private AxisService getAxisService(String serviceName) {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getServiceForActivation(serviceName);
        try {
            if (axisService == null && GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)axisConfiguration).containsKey(serviceName)) {
                GhostDeployerUtils.waitForServiceToLeaveTransit((String)serviceName, (AxisConfiguration)this.getAxisConfig());
                axisService = axisConfiguration.getServiceForActivation(serviceName);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error occurred while service : " + serviceName + " is trying to leave transit"), (Throwable)axisFault);
        }
        return axisService;
    }

    private AxisOperation getAxisOperation(String serviceName, String operationName) {
        return this.getAxisService(serviceName).getOperation(new QName(operationName));
    }

    public StatisticData getWebappRelatedData(String webAppName) {
        try {
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            StatisticData statisticData = ComputeData.map.get(tenantId).get(webAppName);
            return statisticData;
        }
        catch (Exception e) {
            return null;
        }
    }
}

