/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.module;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.internal.ResponseTimeCalculator;

public class InOutMEPHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(InOutMEPHandler.class);

    public Handler.InvocationResponse invoke(MessageContext outMsgContext) throws AxisFault {
        if (outMsgContext.getEnvelope() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (outMsgContext.getFLOW() != 2 && outMsgContext.getFLOW() != 4) {
            log.error((Object)("InOutMEPHandler not deployed in OUT/OUT_FAULT flow. Flow: " + outMsgContext.getFLOW()));
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            AxisService axisService = outMsgContext.getAxisService();
            if (axisService == null) {
                this.updateStatistics(outMsgContext);
                return Handler.InvocationResponse.CONTINUE;
            }
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup()) || axisService.isClientSide()) {
                return Handler.InvocationResponse.CONTINUE;
            }
            AxisOperation axisOperation = outMsgContext.getAxisOperation();
            if (axisOperation != null && axisOperation.isControlOperation()) {
                return Handler.InvocationResponse.CONTINUE;
            }
            if (axisOperation != null) {
                String mep = axisOperation.getMessageExchangePattern();
                if (mep != null && (mep.equals("http://www.w3.org/ns/wsdl/out-in") || mep.equals("http://www.w3.org/ns/wsdl/out-only") || mep.equals("http://www.w3.org/ns/wsdl/out-opt-in"))) {
                    return Handler.InvocationResponse.CONTINUE;
                }
                Parameter inOpCounter = axisOperation.getParameter("wso2statistics.InOperationCounter");
                if (inOpCounter == null) {
                    log.error((Object)("wso2statistics.InOperationCounter has not been set for operation " + axisService.getName() + "." + axisOperation.getName()));
                    return Handler.InvocationResponse.CONTINUE;
                }
                ((AtomicInteger)inOpCounter.getValue()).incrementAndGet();
                Parameter outOpCounter = axisOperation.getParameter("wso2statistics.OutOperationCounter");
                if (outOpCounter != null) {
                    ((AtomicInteger)outOpCounter.getValue()).incrementAndGet();
                } else {
                    log.error((Object)("wso2statistics.OutOperationCounter has not been set for operation " + axisService.getName() + "." + axisOperation.getName()));
                    return Handler.InvocationResponse.CONTINUE;
                }
            }
            this.updateStatistics(outMsgContext);
        }
        catch (Throwable e) {
            log.error((Object)"Could not call InOutMEPHandler.invoke", e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void updateStatistics(MessageContext outMsgContext) throws AxisFault {
        Parameter globalRequestCounter = outMsgContext.getParameter("wso2statistics.GlobalRequestCounter");
        ((AtomicInteger)globalRequestCounter.getValue()).incrementAndGet();
        Parameter globalResponseCounter = outMsgContext.getParameter("wso2statistics.GlobalResponseCounter");
        ((AtomicInteger)globalResponseCounter.getValue()).incrementAndGet();
        this.updateCurrentInvocationGlobalStatistics(outMsgContext);
        ResponseTimeCalculator.calculateResponseTimes(outMsgContext);
    }

    private void updateCurrentInvocationGlobalStatistics(MessageContext outMsgContext) throws AxisFault {
        outMsgContext.setProperty("wso2statistics.GlobalCurrentRequestCounter", (Object)1);
        outMsgContext.setProperty("wso2statistics.GlobalCurrentResponseCounter", (Object)1);
        outMsgContext.setProperty("wso2statistics.GlobalCurrentFaultCounter", (Object)0);
    }
}

