/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.module;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.internal.ResponseTimeCalculator;

public class InOnlyMEPHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(InOnlyMEPHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getEnvelope() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgContext.getFLOW() != 1 && msgContext.getFLOW() != 3) {
            log.error((Object)("InOnlyMEPHandler not deployed in IN/IN_FAULT flow. Flow: " + msgContext.getFLOW()));
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            msgContext.setProperty("wso2statistics.request.received.time", (Object)("" + System.currentTimeMillis()));
        }
        catch (Throwable e) {
            log.error((Object)"Could not call InOnlyMEPHandler.invoke", e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void flowComplete(MessageContext msgContext) {
        block9: {
            if (msgContext.getEnvelope() == null) {
                return;
            }
            AxisService axisService = msgContext.getAxisService();
            if (axisService == null || SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup()) || axisService.isClientSide()) {
                return;
            }
            try {
                String mep;
                OperationContext opContext = msgContext.getOperationContext();
                if (opContext == null || !opContext.isComplete()) break block9;
                AxisOperation axisOp = opContext.getAxisOperation();
                if (axisOp != null && axisOp.isControlOperation()) {
                    return;
                }
                if (axisOp == null || (mep = axisOp.getMessageExchangePattern()) == null || !mep.equals("http://www.w3.org/ns/wsdl/in-only") && !mep.equals("http://www.w3.org/ns/wsdl/robust-in-only")) break block9;
                AxisOperation axisOperation = msgContext.getAxisOperation();
                if (axisOperation != null) {
                    Parameter operationParameter = axisOperation.getParameter("wso2statistics.InOperationCounter");
                    if (operationParameter == null) {
                        log.error((Object)("wso2statistics.InOperationCounter has not been set for operation " + axisService.getName() + "." + axisOperation.getName()));
                        return;
                    }
                    ((AtomicInteger)operationParameter.getValue()).incrementAndGet();
                    try {
                        ResponseTimeCalculator.calculateResponseTimes(msgContext);
                    }
                    catch (AxisFault axisFault) {
                        log.error((Object)"Cannot compute response times", (Throwable)axisFault);
                    }
                }
                Parameter globalRequestCounter = msgContext.getParameter("wso2statistics.GlobalRequestCounter");
                ((AtomicInteger)globalRequestCounter.getValue()).incrementAndGet();
                this.updateCurrentInvocationGlobalStatistics(msgContext);
            }
            catch (Throwable e) {
                log.error((Object)"Could not call InOnlyMEPHandler.flowComplete", e);
            }
        }
    }

    private void updateCurrentInvocationGlobalStatistics(MessageContext msgContext) {
        msgContext.setProperty("wso2statistics.GlobalCurrentRequestCounter", (Object)1);
        msgContext.setProperty("wso2statistics.GlobalCurrentResponseCounter", (Object)0);
        msgContext.setProperty("wso2statistics.GlobalCurrentFaultCounter", (Object)0);
    }
}

