/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.module;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.internal.ResponseTimeCalculator;

public class FaultHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(FaultHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        MessageContext inMsgCtx = (MessageContext)msgContext.getProperty("axis2.inMsgContext");
        if (msgContext.getEnvelope() == null || inMsgCtx.getEnvelope() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            AxisService axisService = msgContext.getAxisService();
            if (axisService == null) {
                this.updateStatistics(msgContext);
                return Handler.InvocationResponse.CONTINUE;
            }
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup()) || axisService.isClientSide()) {
                return Handler.InvocationResponse.CONTINUE;
            }
            AxisOperation axisOperation = msgContext.getAxisOperation();
            if (axisOperation != null) {
                String mep = axisOperation.getMessageExchangePattern();
                if (mep != null && (mep.equals("http://www.w3.org/ns/wsdl/out-in") || mep.equals("http://www.w3.org/ns/wsdl/out-only") || mep.equals("http://www.w3.org/ns/wsdl/out-opt-in"))) {
                    return Handler.InvocationResponse.CONTINUE;
                }
                Parameter parameter = axisOperation.getParameter("wso2statistics.OperationFaultCounter");
                if (parameter != null) {
                    ((AtomicInteger)parameter.getValue()).incrementAndGet();
                } else {
                    AtomicInteger counter = new AtomicInteger(0);
                    counter.incrementAndGet();
                    parameter = new Parameter();
                    parameter.setName("wso2statistics.OperationFaultCounter");
                    parameter.setValue((Object)counter);
                    axisOperation.addParameter(parameter);
                }
                Parameter operationParameter = axisOperation.getParameter("wso2statistics.InOperationCounter");
                if (operationParameter != null) {
                    ((AtomicInteger)operationParameter.getValue()).incrementAndGet();
                } else {
                    AtomicInteger operationCounter = new AtomicInteger(1);
                    operationParameter = new Parameter();
                    operationParameter.setName("wso2statistics.InOperationCounter");
                    operationParameter.setValue((Object)operationCounter);
                    axisOperation.addParameter(operationParameter);
                }
            }
            this.updateStatistics(msgContext);
        }
        catch (Throwable e) {
            log.error((Object)"Could not call FaultHandler.invoke", e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void updateStatistics(MessageContext msgContext) throws AxisFault {
        Parameter globalRequestCounter = msgContext.getParameter("wso2statistics.GlobalRequestCounter");
        ((AtomicInteger)globalRequestCounter.getValue()).incrementAndGet();
        Parameter globalFaultCounter = msgContext.getParameter("wso2statistics.GlobalFaultCounter");
        ((AtomicInteger)globalFaultCounter.getValue()).incrementAndGet();
        this.updateCurrentInvocationGlobalStatistics(msgContext);
        ResponseTimeCalculator.calculateResponseTimes(msgContext);
    }

    private void updateCurrentInvocationGlobalStatistics(MessageContext msgContext) throws AxisFault {
        msgContext.setProperty("wso2statistics.GlobalCurrentRequestCounter", (Object)1);
        msgContext.setProperty("wso2statistics.GlobalCurrentResponseCounter", (Object)0);
        msgContext.setProperty("wso2statistics.GlobalCurrentFaultCounter", (Object)1);
    }
}

