/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.internal;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.statistics.StatisticsAxis2ConfigurationContextObserver;
import org.wso2.carbon.statistics.services.StatisticsAdmin;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.MBeanRegistrar;

@Component(name="statistics.service.component", immediate=true)
public class StatisticsServiceComponent {
    private static final Log log = LogFactory.getLog(StatisticsServiceComponent.class);
    private ConfigurationContext configContext;
    private ServerConfigurationService serverConfig;
    private ServiceRegistration statAdminServiceRegistration;
    private ServiceRegistration axisConfigCtxObserverServiceRegistration;
    private RegistryService registryService;
    private static RealmService realmService;

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            this.configContext.getAxisConfiguration().engageModule("wso2statistics");
            this.registerMBeans(this.serverConfig);
            BundleContext bundleCtx = ctxt.getBundleContext();
            this.statAdminServiceRegistration = bundleCtx.registerService(SystemStatisticsUtil.class.getName(), (Object)new SystemStatisticsUtil(), null);
            this.axisConfigCtxObserverServiceRegistration = bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new StatisticsAxis2ConfigurationContextObserver(), null);
            log.debug((Object)"Statistics bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Statistics bundle", e);
        }
    }

    public RealmService getRealmService() {
        return realmService;
    }

    protected void setRealmService(RealmService realmService) {
        StatisticsServiceComponent.realmService = realmService;
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        this.statAdminServiceRegistration.unregister();
        this.axisConfigCtxObserverServiceRegistration.unregister();
        log.debug((Object)"Statistics bundle is deactivated");
    }

    private void registerMBeans(ServerConfigurationService serverConfig) {
        MBeanRegistrar.registerMBean((Object)new StatisticsAdmin());
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        AxisConfiguration axisConf = this.configContext.getAxisConfiguration();
        if (axisConf != null) {
            AxisModule statModule = axisConf.getModule("wso2statistics");
            if (statModule != null) {
                try {
                    axisConf.disengageModule(statModule);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Failed disengage module: wso2statistics");
                }
            }
            this.configContext = null;
        }
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfig = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfig = null;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        this.registryService = null;
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }
}

