/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.statistics.internal.ResponseTimeProcessor;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;

public class ResponseTimeCalculator {
    private static Log log = LogFactory.getLog(ResponseTimeCalculator.class);

    public static void calculateResponseTimes(MessageContext messageContext) throws AxisFault {
        Object receivedTime;
        OperationContext opctx = messageContext.getOperationContext();
        MessageContext inMsgCtx = opctx != null ? opctx.getMessageContext("In") : (MessageContext)messageContext.getProperty("axis2.inMsgContext");
        if (inMsgCtx == null) {
            inMsgCtx = messageContext;
        }
        if ((receivedTime = inMsgCtx.getProperty("wso2statistics.request.received.time")) == null) {
            log.error((Object)"wso2statistics.request.received.time is null in the IN MessageContext");
            return;
        }
        long responseTime = System.currentTimeMillis() - Long.parseLong(receivedTime.toString());
        ResponseTimeCalculator.updateCurrentInvocationStatistic(messageContext, responseTime);
        Parameter globalReqCounterParam = inMsgCtx.getParameter("wso2statistics.GlobalRequestCounter");
        int globalReqCount = ((AtomicInteger)globalReqCounterParam.getValue()).get();
        Parameter processor = inMsgCtx.getParameter("wso2statistics.ResponseTimeProcessor");
        if (processor != null) {
            ((ResponseTimeProcessor)processor.getValue()).addResponseTime(responseTime, globalReqCount);
        }
        if (opctx != null) {
            AxisService axisService;
            AxisOperation axisOperation = opctx.getAxisOperation();
            if (axisOperation != null) {
                Parameter parameter = axisOperation.getParameter("wso2statistics.OperationResponseTimeProc");
                Parameter opReqCounterParam = axisOperation.getParameter("wso2statistics.InOperationCounter");
                int opReqCount = ((AtomicInteger)opReqCounterParam.getValue()).get();
                if (parameter != null) {
                    ((ResponseTimeProcessor)parameter.getValue()).addResponseTime(responseTime, opReqCount);
                } else {
                    log.error((Object)("wso2statistics.OperationResponseTimeProc has not been set for operation " + axisOperation.getAxisService().getName() + "." + axisOperation.getName()));
                    return;
                }
            }
            if ((axisService = messageContext.getAxisService()) != null) {
                Parameter parameter = axisService.getParameter("wso2statistics.ServiceResponseTimeProc");
                int serviceRequestCount = new SystemStatisticsUtil().getServiceRequestCount(axisService);
                ((ResponseTimeProcessor)parameter.getValue()).addResponseTime(responseTime, serviceRequestCount);
            }
        }
    }

    private static void updateCurrentInvocationStatistic(MessageContext messageContext, long responseTime) throws AxisFault {
        messageContext.setProperty("wso2statistics.global.invocation.response.time", (Object)responseTime);
        if (messageContext.getAxisOperation() != null) {
            Parameter operationResponseTimeParam = new Parameter();
            operationResponseTimeParam.setName("wso2statistics.operation.response.time");
            operationResponseTimeParam.setValue((Object)responseTime);
            messageContext.getAxisOperation().addParameter(operationResponseTimeParam);
        }
        if (messageContext.getAxisService() != null) {
            Parameter serviceResponseTimeParam = new Parameter();
            serviceResponseTimeParam.setName("wso2statistics.service.response.time");
            serviceResponseTimeParam.setValue((Object)responseTime);
            messageContext.getAxisService().addParameter(serviceResponseTimeParam);
        }
    }
}

