/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.util.JavaUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.internal.ResponseTimeProcessor;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.PreAxisConfigurationPopulationObserver;

@Component(name="org.wso2.carbon.statistics.SystemStatisticsDeploymentInterceptor", immediate=true)
public class SystemStatisticsDeploymentInterceptor
implements AxisObserver {
    @Activate
    protected void activate(ComponentContext ctxt) {
        BundleContext bundleCtx = ctxt.getBundleContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
        bundleCtx.registerService(AxisObserver.class.getName(), (Object)this, props);
        PreAxisConfigurationPopulationObserver preAxisConfigObserver = new PreAxisConfigurationPopulationObserver(){

            public void createdAxisConfiguration(AxisConfiguration axisConfiguration) {
                axisConfiguration.addObservers((AxisObserver)new SystemStatisticsDeploymentInterceptor());
            }
        };
        bundleCtx.registerService(PreAxisConfigurationPopulationObserver.class.getName(), (Object)preAxisConfigObserver, null);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }

    public void init(AxisConfiguration axisConfiguration) {
    }

    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        if (SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup()) || axisService.isClientSide()) {
            return;
        }
        if (axisEvent.getEventType() == 1) {
            AxisOperation defaultOp;
            Iterator iter = axisService.getOperations();
            while (iter.hasNext()) {
                AxisOperation op = (AxisOperation)iter.next();
                this.setCountersAndProcessors(op);
            }
            if (JavaUtils.isTrueExplicitly((Object)axisService.getParameterValue("disableOperationValidation")) && (defaultOp = (AxisOperation)axisService.getParameterValue("_default_mediate_operation_")) != null) {
                this.setCountersAndProcessors(defaultOp);
            }
            Parameter responseTimeProcessor = new Parameter();
            responseTimeProcessor.setName("wso2statistics.ServiceResponseTimeProc");
            responseTimeProcessor.setValue((Object)new ResponseTimeProcessor());
            try {
                axisService.addParameter(responseTimeProcessor);
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
    }

    private void setCountersAndProcessors(AxisOperation op) {
        Parameter inOpCounter = new Parameter();
        inOpCounter.setName("wso2statistics.InOperationCounter");
        inOpCounter.setValue((Object)new AtomicInteger(0));
        try {
            op.addParameter(inOpCounter);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        Parameter outOpCounter = new Parameter();
        outOpCounter.setName("wso2statistics.OutOperationCounter");
        outOpCounter.setValue((Object)new AtomicInteger(0));
        try {
            op.addParameter(outOpCounter);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        Parameter responseTimeProcessor = new Parameter();
        responseTimeProcessor.setName("wso2statistics.OperationResponseTimeProc");
        responseTimeProcessor.setValue((Object)new ResponseTimeProcessor());
        try {
            op.addParameter(responseTimeProcessor);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void serviceGroupUpdate(AxisEvent axisEvent, AxisServiceGroup axisServiceGroup) {
    }

    public void moduleUpdate(AxisEvent axisEvent, AxisModule axisModule) {
    }

    public void addParameter(Parameter parameter) throws AxisFault {
    }

    public void removeParameter(Parameter parameter) throws AxisFault {
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String s) {
        return null;
    }

    public ArrayList<Parameter> getParameters() {
        return null;
    }

    public boolean isParameterLocked(String s) {
        return false;
    }
}

