/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class StatisticsAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private Log log = LogFactory.getLog(StatisticsAxis2ConfigurationContextObserver.class);

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        try {
            if (axisConfig.getModule("wso2statistics") != null) {
                axisConfig.engageModule("wso2statistics");
            }
        }
        catch (Throwable e) {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            String msg = carbonContext.getTenantDomain() != null ? "Could not globally engage wso2statistics module to tenant " + carbonContext.getTenantDomain() + "[" + carbonContext.getTenantId() + "]" : "Could not globally engage wso2statistics module to super tenant ";
            this.log.error((Object)msg, e);
        }
    }
}

