/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.updater.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.wso2.carbon.logging.updater.LogConfigUpdater;
import org.wso2.carbon.logging.updater.LoggingUpdaterException;
import org.wso2.carbon.logging.updater.LoggingUpdaterUtil;
import org.wso2.carbon.logging.updater.internal.DataHolder;

@Component(name="org.wso2.carbon.logging.updater", immediate=true, property={"event.topics=org/ops4j/pax/logging/Configuration"})
public class LoggingUpdaterServiceComponent
implements EventHandler {
    static final Log log = LogFactory.getLog(LoggingUpdaterServiceComponent.class);
    private ConfigurationAdmin configurationAdmin;

    @Reference(name="osgi.configadmin.service", service=ConfigurationAdmin.class, unbind="unsetConfigAdminService", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    public void setConfigAdminService(ConfigurationAdmin configAdminService) {
        DataHolder.getInstance().setConfigurationAdmin(configAdminService);
    }

    @Activate
    public void activate(ComponentContext componentContext) {
        try {
            DataHolder.getInstance().setModifiedTime(LoggingUpdaterUtil.readModifiedTime());
            LogConfigUpdater logConfigUpdater = new LogConfigUpdater(DataHolder.getInstance().getConfigurationAdmin());
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            DataHolder.getInstance().setScheduledExecutorService(scheduledExecutorService);
            scheduledExecutorService.scheduleAtFixedRate(logConfigUpdater, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }
        catch (LoggingUpdaterException e) {
            log.error((Object)"Error while Activating LoggingUpdater component", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        DataHolder.getInstance().getScheduledExecutorService().shutdown();
    }

    public void unsetConfigAdminService(ConfigurationAdmin configurationAdmin) {
        DataHolder.getInstance().setConfigurationAdmin(null);
    }

    public void handleEvent(Event event) {
        if (event.containsProperty("exception")) {
            Object property = event.getProperty("exception");
            Exception exception = (Exception)property;
            log.error((Object)("Unable to apply logging configuration " + exception.getMessage()));
            log.error((Object)"Continuing with previous logging configuration");
        } else {
            log.info((Object)"Logging configuration applied successfully");
        }
    }
}

