/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.updater;

import java.io.IOException;
import java.nio.file.attribute.FileTime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.wso2.carbon.logging.updater.LoggingUpdaterException;
import org.wso2.carbon.logging.updater.LoggingUpdaterUtil;
import org.wso2.carbon.logging.updater.internal.DataHolder;

public class LogConfigUpdater
implements Runnable {
    static final Log LOG = LogFactory.getLog(LogConfigUpdater.class);
    private ConfigurationAdmin configurationAdmin;

    public LogConfigUpdater(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public void run() {
        try {
            FileTime modifiedTime = LoggingUpdaterUtil.readModifiedTime();
            FileTime lastModifiedTime = DataHolder.getInstance().getModifiedTime();
            if (lastModifiedTime != null && modifiedTime.compareTo(lastModifiedTime) > 0) {
                DataHolder.getInstance().setModifiedTime(modifiedTime);
                this.updateLoggingConfiguration();
            }
        }
        catch (LoggingUpdaterException e) {
            LOG.error((Object)"Error while reading modified Time", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while updating logging configuration", (Throwable)e);
        }
    }

    private void updateLoggingConfiguration() throws IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.logging", "?");
        configuration.update();
    }
}

