/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLExecutionException;

public class NamedPreparedStatement {
    private PreparedStatement preparedStatement;
    private List<String> fields = new ArrayList<String>();

    public NamedPreparedStatement(Connection connection, String sqlQuery, Map<String, Integer> repetition) throws SQLException {
        int pos;
        while ((pos = sqlQuery.indexOf(96)) != -1) {
            int end = sqlQuery.substring(pos + 1).indexOf(96);
            if (end == -1) {
                throw new SQLException("Cannot find the end of the placeholder.");
            }
            this.fields.add(sqlQuery.substring(pos + 1, (end += pos) + 1));
            StringBuilder builder = new StringBuilder("?");
            if (repetition.get(sqlQuery.substring(pos + 1, end)) != null) {
                for (int i = 0; i < repetition.get(sqlQuery.substring(pos + 1, end)) - 1; ++i) {
                    builder.append(", ?");
                }
            }
            sqlQuery = String.format("%s %s %s", sqlQuery.substring(0, pos), builder.toString(), sqlQuery.substring(end + 2));
        }
        this.preparedStatement = connection.prepareStatement(sqlQuery);
    }

    public NamedPreparedStatement(Connection connection, String sqlQuery) throws SQLException {
        this(connection, sqlQuery, new HashMap<String, Integer>());
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setLong(String name, long value) throws SQLException, SQLExecutionException {
        this.preparedStatement.setLong(this.getIndex(name), value);
    }

    public void setInt(String name, int value) throws SQLException, SQLExecutionException {
        this.preparedStatement.setInt(this.getIndex(name), value);
    }

    public void setString(String name, String value) throws SQLException, SQLExecutionException {
        this.preparedStatement.setString(this.getIndex(name), value);
    }

    public void setString(String name, List<String> values) throws SQLException, SQLExecutionException {
        int indexInc = 0;
        for (String value : values) {
            this.preparedStatement.setString(this.getIndex(name) + indexInc, value);
            ++indexInc;
        }
    }

    private int getIndex(String name) throws SQLExecutionException {
        int index = this.fields.indexOf(name);
        if (index < 0) {
            throw new SQLExecutionException("Invalid index name given in the SQL script. " + name);
        }
        this.fields.set(index, "-");
        return index + 1;
    }
}

