/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.sql;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLReaderException;
import org.wso2.carbon.privacy.forgetme.sql.sql.SQLQuery;
import org.wso2.carbon.privacy.forgetme.sql.sql.SQLQueryType;
import org.wso2.carbon.privacy.forgetme.sql.util.LambdaExceptionUtils;

public class SQLFileReader {
    private static final Logger log = LoggerFactory.getLogger(SQLFileReader.class);
    private static final String PROPERTIES_EXTENSION = ".properties";
    private Path path;

    public SQLFileReader(String folderPath) {
        this.path = Paths.get(folderPath, new String[0]);
    }

    public SQLFileReader(Path folderPath) {
        this.path = folderPath;
    }

    public Map<String, SQLQuery> readAllQueries() throws SQLReaderException {
        HashMap<String, SQLQuery> sqlQueries = new HashMap<String, SQLQuery>();
        try (Stream<Path> pathStream = Files.walk(this.path, new FileVisitOption[0]);){
            pathStream.forEach(LambdaExceptionUtils.rethrowConsumer(paths -> {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.sql");
                if (matcher.matches(paths.getFileName())) {
                    SQLQuery sqlQuery = new SQLQuery(new String(Files.readAllBytes(paths)));
                    sqlQuery.setBaseDirectory(paths.getParent().toFile().getName());
                    sqlQuery.setSqlQueryType(this.getQueryTypeForSQLQuery(paths.getFileName().toString(), paths.getParent()));
                    sqlQuery.setFollowedByQuery(this.getFollowedBySQLQuery(paths.getFileName().toString(), paths.getParent()));
                    sqlQueries.put(paths.getFileName().toString(), sqlQuery);
                    if (log.isDebugEnabled()) {
                        log.debug("Following SQL query read from the file: {}", (Object)sqlQuery);
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new SQLReaderException("Error occurred while reading the SQL files.", e);
        }
        return sqlQueries;
    }

    public SQLQueryType getQueryTypeForSQLQuery(String queryFileName, Path basePath) throws SQLReaderException {
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            throw new SQLReaderException("Invalid base path. Base path should be a directory.");
        }
        if (Files.exists(Paths.get(basePath.toString(), queryFileName + PROPERTIES_EXTENSION), new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newInputStream(Paths.get(basePath.toString(), queryFileName + PROPERTIES_EXTENSION), new OpenOption[0]));
                String type = properties.getProperty("type");
                if (log.isDebugEnabled()) {
                    log.debug("Properties file found for {} and type is {}", (Object)queryFileName, (Object)type);
                }
                return SQLQueryType.valueOf(type);
            }
            catch (IOException e) {
                throw new SQLReaderException("Error occurred while reading the SQL property files.", e);
            }
        }
        return SQLQueryType.DOMAIN_SEPARATED;
    }

    public String getFollowedBySQLQuery(String queryFileName, Path basePath) throws SQLReaderException {
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            throw new SQLReaderException("Invalid base path. Base path should be a directory.");
        }
        if (Files.exists(Paths.get(basePath.toString(), queryFileName + PROPERTIES_EXTENSION), new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newInputStream(Paths.get(basePath.toString(), queryFileName + PROPERTIES_EXTENSION), new OpenOption[0]));
                String followedByQuery = properties.getProperty("followedByQuery");
                if (log.isDebugEnabled()) {
                    log.debug("Properties file found for {} and followedByQuery is {}", (Object)queryFileName, (Object)followedByQuery);
                }
                return followedByQuery;
            }
            catch (IOException e) {
                throw new SQLReaderException("Error occurred while reading the SQL property files.", e);
            }
        }
        return null;
    }
}

