/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.module;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.sql.config.DataSourceConfig;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;
import org.wso2.carbon.privacy.forgetme.sql.module.Module;
import org.wso2.carbon.privacy.forgetme.sql.sql.UserSQLQuery;
import org.wso2.carbon.privacy.forgetme.sql.util.NamedPreparedStatement;

public class SPAppSQLExecutionModule
implements Module<Map<String, UserSQLQuery>> {
    private static final Logger log = LoggerFactory.getLogger(SPAppSQLExecutionModule.class);
    private static final String USERNAME = "username";
    private static final String TENANT_ID = "tenant_id";
    private static final String USER_STORE_DOMAIN = "user_store_domain";
    private static final String MODIFIED_APP_NAME = "modifiedAppName";
    private static final String MODIFIED_DESCRIPTION = "modifiedDescription";
    private static final String PSEUDONYM = "pseudonym";
    private DataSource dataSource;

    public SPAppSQLExecutionModule(DataSourceConfig dataSourceConfig) throws SQLModuleException {
        try {
            this.dataSource = dataSourceConfig.getDatasource();
            if (log.isDebugEnabled()) {
                log.debug("Data source initialized with name: {}.", this.dataSource.getClass());
            }
        }
        catch (SQLModuleException e) {
            throw new SQLModuleException("Error occurred while initializing the data source.", (Throwable)((Object)e));
        }
    }

    @Override
    public void execute(Map<String, UserSQLQuery> queries) throws ModuleException {
        if (this.dataSource == null) {
            log.warn("No data source configured for name: " + queries.get("SELECT").getSqlQuery().getBaseDirectory());
            return;
        }
        String username = queries.get("SELECT").getUserIdentifier().getUsername();
        try (Connection connection = this.dataSource.getConnection();){
            NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, queries.get("SELECT").getSqlQuery().toString());
            namedPreparedStatement.setString(USERNAME, username);
            namedPreparedStatement.setInt(TENANT_ID, queries.get("SELECT").getUserIdentifier().getTenantId());
            namedPreparedStatement.setString(USER_STORE_DOMAIN, queries.get("SELECT").getUserIdentifier().getUserStoreDomain());
            ResultSet rs = namedPreparedStatement.getPreparedStatement().executeQuery();
            String modifiedApplicationName = null;
            String modifiedDescription = null;
            while (rs.next()) {
                String appName = rs.getString("APP_NAME");
                String description = rs.getString("DESCRIPTION");
                modifiedApplicationName = appName.replaceAll("(^" + username + "_)", queries.get("SELECT").getUserIdentifier().getPseudonym() + "_");
                modifiedDescription = description.replaceAll("(\\s" + username + "_)", " " + queries.get("SELECT").getUserIdentifier().getPseudonym() + "_");
            }
            if (modifiedApplicationName != null && modifiedDescription != null) {
                NamedPreparedStatement namedPreparedStatement2 = new NamedPreparedStatement(connection, queries.get("UPDATE").getSqlQuery().toString());
                namedPreparedStatement2.setString(MODIFIED_APP_NAME, modifiedApplicationName);
                namedPreparedStatement2.setString(MODIFIED_DESCRIPTION, modifiedDescription);
                namedPreparedStatement2.setString(PSEUDONYM, queries.get("SELECT").getUserIdentifier().getPseudonym());
                namedPreparedStatement2.setString(USERNAME, username);
                namedPreparedStatement2.setString(USER_STORE_DOMAIN, queries.get("SELECT").getUserIdentifier().getUserStoreDomain());
                namedPreparedStatement2.setInt(TENANT_ID, queries.get("SELECT").getUserIdentifier().getTenantId());
                namedPreparedStatement2.getPreparedStatement().executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug("Executed the sql query: {}.", (Object)queries.get("SELECT").getSqlQuery().toString());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLModuleException(e);
        }
    }
}

