/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.module;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.sql.config.DataSourceConfig;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;
import org.wso2.carbon.privacy.forgetme.sql.module.Module;
import org.wso2.carbon.privacy.forgetme.sql.sql.UserSQLQuery;
import org.wso2.carbon.privacy.forgetme.sql.util.NamedPreparedStatement;

public class DomainAppendedSQLExecutionModule
implements Module<UserSQLQuery> {
    private static final Logger log = LoggerFactory.getLogger(DomainAppendedSQLExecutionModule.class);
    private static final String USERNAME = "username";
    private static final String TENANT_ID = "tenant_id";
    private static final String TENANT_DOMAIN = "tenant_domain";
    private static final String PSEUDONYM = "pseudonym";
    private static final String PRIMARY_DOMAIN = "PRIMARY";
    private static final String DOMAIN_SEPARATOR = "/";
    private DataSource dataSource;

    public DomainAppendedSQLExecutionModule(DataSourceConfig dataSourceConfig) throws SQLModuleException {
        try {
            this.dataSource = dataSourceConfig.getDatasource();
            if (log.isDebugEnabled()) {
                log.debug("Data source initialized with name: {}.", this.dataSource.getClass());
            }
        }
        catch (SQLModuleException e) {
            throw new SQLModuleException("Error occurred while initializing the data source.", (Throwable)((Object)e));
        }
    }

    @Override
    public void execute(UserSQLQuery userSQLQuery) throws ModuleException {
        if (this.dataSource == null) {
            log.warn("No data source configured for name: " + userSQLQuery.getSqlQuery().getBaseDirectory());
            return;
        }
        String username = userSQLQuery.getUserIdentifier().getUsername();
        if (!StringUtils.equals((String)userSQLQuery.getUserIdentifier().getUserStoreDomain(), (String)PRIMARY_DOMAIN)) {
            username = userSQLQuery.getUserIdentifier().getUserStoreDomain() + DOMAIN_SEPARATOR + username;
        }
        try (Connection connection = this.dataSource.getConnection();){
            int i;
            NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, userSQLQuery.getSqlQuery().toString());
            for (i = 0; i < userSQLQuery.getNumberOfPlacesToReplace(USERNAME); ++i) {
                namedPreparedStatement.setString(USERNAME, username);
            }
            for (i = 0; i < userSQLQuery.getNumberOfPlacesToReplace(TENANT_ID); ++i) {
                namedPreparedStatement.setInt(TENANT_ID, userSQLQuery.getUserIdentifier().getTenantId());
            }
            for (i = 0; i < userSQLQuery.getNumberOfPlacesToReplace(PSEUDONYM); ++i) {
                namedPreparedStatement.setString(PSEUDONYM, userSQLQuery.getUserIdentifier().getPseudonym());
            }
            namedPreparedStatement.getPreparedStatement().execute();
            if (log.isDebugEnabled()) {
                log.debug("Executed the sql query: {}.", (Object)userSQLQuery.getSqlQuery().toString());
            }
        }
        catch (SQLException e) {
            throw new SQLModuleException(e);
        }
    }
}

