/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.module;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.sql.config.DataSourceConfig;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;
import org.wso2.carbon.privacy.forgetme.sql.module.Module;
import org.wso2.carbon.privacy.forgetme.sql.sql.UserSQLQuery;
import org.wso2.carbon.privacy.forgetme.sql.util.NamedPreparedStatement;

public class AMApplicationRegistrationSQLExecutionModule
implements Module<Map<String, UserSQLQuery>> {
    private static final Logger log = LoggerFactory.getLogger(AMApplicationRegistrationSQLExecutionModule.class);
    private static final String TENANT_ID = "tenant_id";
    private static final String MODIFIED_STRING = "modifiedString";
    private static final String SUBSCRIBER_ID = "subscriberId";
    private static final String SUPER_TENANT = "carbon.super";
    private static final String TENANT_DOMAIN_SEPARATOR = "@";
    private DataSource dataSource;

    public AMApplicationRegistrationSQLExecutionModule(DataSourceConfig dataSourceConfig) throws SQLModuleException {
        try {
            this.dataSource = dataSourceConfig.getDatasource();
            if (log.isDebugEnabled()) {
                log.debug("Data source initialized with name: {}.", this.dataSource.getClass());
            }
        }
        catch (SQLModuleException e) {
            throw new SQLModuleException("Error occurred while initializing the data source.", (Throwable)((Object)e));
        }
    }

    @Override
    public void execute(Map<String, UserSQLQuery> queries) throws ModuleException {
        if (this.dataSource == null) {
            log.warn("No data source configured for name: " + queries.get("SELECT").getSqlQuery().getBaseDirectory());
            return;
        }
        String username = queries.get("SELECT").getUserIdentifier().getUsername();
        if (!StringUtils.equals((String)queries.get("SELECT").getUserIdentifier().getTenantDomain(), (String)SUPER_TENANT)) {
            username = username + TENANT_DOMAIN_SEPARATOR + queries.get("SELECT").getUserIdentifier().getTenantDomain();
        }
        try (Connection connection = this.dataSource.getConnection();){
            NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, queries.get("SELECT").getSqlQuery().toString());
            namedPreparedStatement.setInt(TENANT_ID, queries.get("SELECT").getUserIdentifier().getTenantId());
            ResultSet rs = namedPreparedStatement.getPreparedStatement().executeQuery();
            String modifiedInputString = null;
            int subscriberId = -1;
            while (rs.next()) {
                String inputs = rs.getString("INPUTS");
                subscriberId = rs.getInt("SUBSCRIBER_ID");
                modifiedInputString = inputs.replaceAll("username\":\"" + username + "\"", "username\":\"" + queries.get("SELECT").getUserIdentifier().getPseudonym() + "\"");
            }
            if (modifiedInputString != null && subscriberId != -1) {
                NamedPreparedStatement namedPreparedStatement2 = new NamedPreparedStatement(connection, queries.get("UPDATE").getSqlQuery().toString());
                namedPreparedStatement2.setString(MODIFIED_STRING, modifiedInputString);
                namedPreparedStatement2.setInt(SUBSCRIBER_ID, subscriberId);
                namedPreparedStatement2.getPreparedStatement().executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug("Executed the sql query: {}.", (Object)queries.get("SELECT").getSqlQuery().toString());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLModuleException(e);
        }
    }
}

