/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.instructions;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeResult;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.sql.config.DataSourceConfig;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;
import org.wso2.carbon.privacy.forgetme.sql.instructions.DatasourceProcessorConfig;
import org.wso2.carbon.privacy.forgetme.sql.module.AMApplicationRegistrationSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.DomainAppendedPseudonymSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.DomainAppendedSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.DomainSeparatedSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.IDNOauthConsumerAppsSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.Module;
import org.wso2.carbon.privacy.forgetme.sql.module.SPAppSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.TenantAppendedSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.module.TenantSpecificAppendedSQLExecutionModule;
import org.wso2.carbon.privacy.forgetme.sql.sql.SQLFileReader;
import org.wso2.carbon.privacy.forgetme.sql.sql.SQLQuery;
import org.wso2.carbon.privacy.forgetme.sql.sql.SQLQueryType;
import org.wso2.carbon.privacy.forgetme.sql.sql.UserSQLQuery;

public class RdbmsForgetMeInstruction
implements ForgetMeInstruction {
    private static final Logger log = LoggerFactory.getLogger(RdbmsForgetMeInstruction.class);
    private Path sqlDir;

    public RdbmsForgetMeInstruction(Path sqlDir) {
        this.sqlDir = sqlDir;
        if (log.isDebugEnabled()) {
            log.debug("SQL directory path is set to: {}. ", (Object)sqlDir.toString());
        }
    }

    public ForgetMeResult execute(UserIdentifier userIdentifier, ProcessorConfig processorConfig, Environment environment, ReportAppender reportAppender) throws InstructionExecutionException {
        SQLFileReader sqlFileReader = new SQLFileReader(this.sqlDir);
        reportAppender.appendSection("Processing SQL in directory %s", new Object[]{this.sqlDir});
        log.info("Processing SQL in directory {}", (Object)sqlFileReader);
        try {
            Map<String, SQLQuery> sqlQueries = sqlFileReader.readAllQueries();
            for (Map.Entry<String, SQLQuery> entry : sqlQueries.entrySet()) {
                SQLQuery sqlQuery = entry.getValue();
                UserSQLQuery userSQLQuery = new UserSQLQuery();
                userSQLQuery.setSqlQuery(sqlQuery);
                userSQLQuery.setUserIdentifier(userIdentifier);
                String datasourceName = sqlQuery.getBaseDirectory();
                DataSourceConfig dataSourceConfig = ((DatasourceProcessorConfig)processorConfig).getDataSourceConfig(datasourceName);
                switch (sqlQuery.getSqlQueryType()) {
                    case DOMAIN_APPENDED: {
                        Module<UserSQLQuery> sqlExecutionModule = new DomainAppendedSQLExecutionModule(dataSourceConfig);
                        sqlExecutionModule.execute(userSQLQuery);
                        break;
                    }
                    case DOMAIN_SEPARATED: {
                        Module<UserSQLQuery> sqlExecutionModule = new DomainSeparatedSQLExecutionModule(dataSourceConfig);
                        sqlExecutionModule.execute(userSQLQuery);
                        break;
                    }
                    case TENANT_SPECIFIC_APPENDED: {
                        Module<UserSQLQuery> sqlExecutionModule = new TenantSpecificAppendedSQLExecutionModule(dataSourceConfig);
                        sqlExecutionModule.execute(userSQLQuery);
                        break;
                    }
                    case TENANT_APPENDED: {
                        Module<UserSQLQuery> sqlExecutionModule = new TenantAppendedSQLExecutionModule(dataSourceConfig);
                        sqlExecutionModule.execute(userSQLQuery);
                        break;
                    }
                    case AM_APPLICATION_REGISTRATION_UPDATE: {
                        Module<Map<String, UserSQLQuery>> extendedExecutionModule = new AMApplicationRegistrationSQLExecutionModule(dataSourceConfig);
                        extendedExecutionModule.execute(this.getSelectAndUpdateQueries(userSQLQuery, sqlQueries.get(userSQLQuery.getSqlQuery().getFollowedByQuery()), userIdentifier));
                        break;
                    }
                    case IDN_OAUTH_CONSUMER_APPS_UPDATE: {
                        Module<Map<String, UserSQLQuery>> extendedExecutionModule = new IDNOauthConsumerAppsSQLExecutionModule(dataSourceConfig);
                        extendedExecutionModule.execute(this.getSelectAndUpdateQueries(userSQLQuery, sqlQueries.get(userSQLQuery.getSqlQuery().getFollowedByQuery()), userIdentifier));
                        break;
                    }
                    case SP_APP_UPDATE: {
                        Module<Map<String, UserSQLQuery>> extendedExecutionModule = new SPAppSQLExecutionModule(dataSourceConfig);
                        extendedExecutionModule.execute(this.getSelectAndUpdateQueries(userSQLQuery, sqlQueries.get(userSQLQuery.getSqlQuery().getFollowedByQuery()), userIdentifier));
                        break;
                    }
                    case SELECT_PROCEEDED_UPDATE: {
                        break;
                    }
                    case DOMAIN_APPENDED_PSEUDONYM: {
                        Module<UserSQLQuery> sqlExecutionModule = new DomainAppendedPseudonymSQLExecutionModule(dataSourceConfig);
                        sqlExecutionModule.execute(userSQLQuery);
                        break;
                    }
                    default: {
                        throw new SQLModuleException("Cannot find a suitable execution module.");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("{} module selected for {} SQL query.", (Object)sqlQuery.getSqlQueryType(), (Object)sqlQuery);
                }
                if (SQLQueryType.SELECT_PROCEEDED_UPDATE.equals((Object)sqlQuery.getSqlQueryType())) continue;
                reportAppender.append("Executed query %s", new Object[]{userSQLQuery});
            }
        }
        catch (ModuleException e) {
            throw new InstructionExecutionException("Error occurred while executing sql from : " + this.sqlDir, (Throwable)e);
        }
        reportAppender.appendSection("Completed all SQLs in directory %s", new Object[]{this.sqlDir});
        log.info("Completed all SQLs in directory {}.", (Object)this.sqlDir);
        return new ForgetMeResult();
    }

    private Map<String, UserSQLQuery> getSelectAndUpdateQueries(UserSQLQuery selectQuery, SQLQuery updateQuery, UserIdentifier userIdentifier) {
        HashMap<String, UserSQLQuery> queries = new HashMap<String, UserSQLQuery>();
        UserSQLQuery updateSQLQuery = new UserSQLQuery();
        updateSQLQuery.setSqlQuery(updateQuery);
        updateSQLQuery.setUserIdentifier(userIdentifier);
        queries.put("SELECT", selectQuery);
        queries.put("UPDATE", updateSQLQuery);
        return queries;
    }
}

