/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.instructions;

import java.nio.file.Path;
import java.util.Map;
import org.wso2.carbon.datasource.core.DataSourceManager;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfigReader;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;
import org.wso2.carbon.privacy.forgetme.sql.instructions.DatasourceProcessorConfig;

public class DatasourceProcessorConfigReader
implements ProcessorConfigReader<DatasourceProcessorConfig> {
    public String getName() {
        return "datasource";
    }

    public DatasourceProcessorConfig readProcessorConfig(Path path, Map<String, String> properties) throws SQLModuleException {
        DataSourceManager dataSourceManager = DataSourceManager.getInstance();
        try {
            dataSourceManager.initDataSources(path.toAbsolutePath().toString());
        }
        catch (DataSourceException e) {
            throw new SQLModuleException("Error occurred while initializing the data source.", e);
        }
        return new DatasourceProcessorConfig(dataSourceManager, properties);
    }
}

