/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.sql.config;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.DataSourceManager;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.privacy.forgetme.sql.exception.SQLModuleException;

public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    private String dataSourceName;
    private DataSourceManager dataSourceManager;

    public DataSourceConfig(String dataSourceName, DataSourceManager dataSourceManager) {
        this.dataSourceName = dataSourceName;
        this.dataSourceManager = dataSourceManager;
    }

    public DataSource getDatasource() throws SQLModuleException {
        if (this.dataSourceManager.getDataSourceRepository() != null) {
            CarbonDataSource carbonDataSource = this.dataSourceManager.getDataSourceRepository().getDataSource(this.dataSourceName);
            if (carbonDataSource != null) {
                return (DataSource)carbonDataSource.getDataSourceObject();
            }
        } else {
            throw new SQLModuleException("Datasource manager is not initialized.");
        }
        log.error("Could not find a datasource for the name : " + this.dataSourceName);
        return null;
    }
}

