/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;

public class PersistenceUtils {
    private static final String NAME_ATT = "name";
    private static final String PORT_ATT = "port";
    private static final String DOMAIN_ATT = "domain";
    private static final String PROTOCOL_ATT = "protocol";
    private static final String INJECT_SEQ_ATT = "injectingSeq";
    private static final String ONERROR_SEQ_ATT = "onErrorSeq";
    private static final String CLASS_IMPL_ATT = "classImpl";
    private static final String PARAM_NAME_ATT = "paramName";
    private static final String PARAM_VALUE_ATT = "paramValue";
    private static final String KEYSTORE_ATT = "keystore";
    private static final String TRUSTSTORE_ATT = "truststore";
    private static final String CLIENTAUTH_ATT = "SSLVerifyClient";
    private static final String SSLPROTOCOL_ATT = "SSLProtocol";
    private static final String HTTPSPROTOCOLS_ATT = "HttpsProtocols";
    private static final String REVOCATIONVERIFIER_ATT = "CertificateRevocationVerifier";
    private static final String PREFERRED_CIPHERS_ATT = "PreferredCiphers";
    private static final QName INBOUND_ENDPOINTS_QN = new QName("inboundEndpoints");
    private static final QName INBOUND_LISTENING_ENDPOINTS_QN = new QName("inboundListeningEndpoints");
    private static final QName INBOUND_POLLING_ENDPOINTS_QN = new QName("inboundPollingingEndpoints");
    private static final QName INBOUND_ENDPOINT_LISTENER_QN = new QName("inboundEndpointListener");
    private static final QName INBOUND_ENDPOINT_POLL_QN = new QName("inboundEndpointPoll");
    private static final QName ENDPOINT_QN = new QName("endpoint");
    private static final QName PARAMS_QN = new QName("inboundParameters");
    private static final QName PARAM_QN = new QName("inboundParameter");
    private static final QName NAME_QN = new QName("name");
    private static final QName PORT_QN = new QName("port");
    private static final QName DOMAIN_QN = new QName("domain");
    private static final QName PROTOCOL_QN = new QName("protocol");
    private static final QName INJECT_SEQ_QN = new QName("injectingSeq");
    private static final QName ONERROR_SEQ_QN = new QName("onErrorSeq");
    private static final QName CLASS_IMPL_QN = new QName("classImpl");
    private static final QName PARAM_NAME_QN = new QName("paramName");
    private static final QName PARAM_VALUE_QN = new QName("paramValue");
    private static final QName KEYSTORE_QN = new QName("keystore");
    private static final QName TRUSTORE_QN = new QName("truststore");
    private static final QName CLIENTAUTH_QN = new QName("SSLVerifyClient");
    private static final QName SSLPROTOCOL_QN = new QName("SSLProtocol");
    private static final QName HTTPSPROTOCOL_QN = new QName("HttpsProtocols");
    private static final QName REVOCATIONVERIFIER_QN = new QName("CertificateRevocationVerifier");
    private static final QName PREFERRED_CIPHERS_QN = new QName("PreferredCiphers");
    private static final String PORT_OFFSET_SYSTEM_VAR = "portOffset";
    private static final String PORT_OFFSET_CONFIG = "Ports.Offset";
    public static final String WEBSOCKET_USE_PORT_OFFSET = "ws.use.port.offset";
    private static OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final OMNamespace nullNS = fac.createOMNamespace("", "");
    private static final Log log = LogFactory.getLog(PersistenceUtils.class);

    public static OMElement convertEndpointInfoToOM(Map<Integer, List<InboundEndpointInfoDTO>> endpointInfo, Map<String, Set<String>> endpointPollingInfo) {
        OMElement endpointElem;
        OMElement listenerElem;
        OMElement rootElement = fac.createOMElement(INBOUND_ENDPOINTS_QN);
        OMElement parentElement = fac.createOMElement(INBOUND_LISTENING_ENDPOINTS_QN, (OMContainer)rootElement);
        for (Map.Entry<Integer, List<InboundEndpointInfoDTO>> entry : endpointInfo.entrySet()) {
            int port = entry.getKey();
            listenerElem = fac.createOMElement(INBOUND_ENDPOINT_LISTENER_QN, (OMContainer)parentElement);
            listenerElem.addAttribute(PORT_ATT, String.valueOf(port), nullNS);
            List<InboundEndpointInfoDTO> tenantDomains = entry.getValue();
            for (InboundEndpointInfoDTO inboundEndpointInfoDTO : tenantDomains) {
                endpointElem = fac.createOMElement(ENDPOINT_QN, (OMContainer)listenerElem);
                endpointElem.addAttribute(NAME_ATT, inboundEndpointInfoDTO.getEndpointName(), nullNS);
                endpointElem.addAttribute(DOMAIN_ATT, inboundEndpointInfoDTO.getTenantDomain(), nullNS);
                endpointElem.addAttribute(PROTOCOL_ATT, inboundEndpointInfoDTO.getProtocol(), nullNS);
                OMElement paramsElem = fac.createOMElement(PARAMS_QN, (OMContainer)endpointElem);
                if (inboundEndpointInfoDTO.getInboundParams() != null) {
                    if (inboundEndpointInfoDTO.getInboundParams().getInjectingSeq() != null) {
                        endpointElem.addAttribute(INJECT_SEQ_ATT, inboundEndpointInfoDTO.getInboundParams().getInjectingSeq(), nullNS);
                    }
                    if (inboundEndpointInfoDTO.getInboundParams().getOnErrorSeq() != null) {
                        endpointElem.addAttribute(ONERROR_SEQ_ATT, inboundEndpointInfoDTO.getInboundParams().getOnErrorSeq(), nullNS);
                    }
                    if (inboundEndpointInfoDTO.getInboundParams().getClassImpl() != null) {
                        endpointElem.addAttribute(CLASS_IMPL_ATT, inboundEndpointInfoDTO.getInboundParams().getClassImpl(), nullNS);
                    }
                    for (Map.Entry<Object, Object> e : inboundEndpointInfoDTO.getInboundParams().getProperties().entrySet()) {
                        OMElement paramElem = fac.createOMElement(PARAM_QN, (OMContainer)paramsElem);
                        paramElem.addAttribute(PARAM_NAME_ATT, (String)e.getKey(), nullNS);
                        paramElem.addAttribute(PARAM_VALUE_ATT, (String)e.getValue(), nullNS);
                    }
                }
                if (inboundEndpointInfoDTO.getSslConfiguration() == null) continue;
                if (inboundEndpointInfoDTO.getSslConfiguration().getKeyStore() != null) {
                    endpointElem.addAttribute(KEYSTORE_ATT, inboundEndpointInfoDTO.getSslConfiguration().getKeyStore(), nullNS);
                }
                if (inboundEndpointInfoDTO.getSslConfiguration().getTrustStore() != null) {
                    endpointElem.addAttribute(TRUSTSTORE_ATT, inboundEndpointInfoDTO.getSslConfiguration().getTrustStore(), nullNS);
                }
                if (inboundEndpointInfoDTO.getSslConfiguration().getClientAuthEl() != null) {
                    endpointElem.addAttribute(CLIENTAUTH_ATT, inboundEndpointInfoDTO.getSslConfiguration().getClientAuthEl(), nullNS);
                }
                if (inboundEndpointInfoDTO.getSslConfiguration().getSslProtocol() != null) {
                    endpointElem.addAttribute(SSLPROTOCOL_ATT, inboundEndpointInfoDTO.getSslConfiguration().getSslProtocol(), nullNS);
                }
                if (inboundEndpointInfoDTO.getSslConfiguration().getHttpsProtocolsEl() != null) {
                    endpointElem.addAttribute(HTTPSPROTOCOLS_ATT, inboundEndpointInfoDTO.getSslConfiguration().getHttpsProtocolsEl(), nullNS);
                }
                if (inboundEndpointInfoDTO.getSslConfiguration().getRevocationVerifier() == null) continue;
                endpointElem.addAttribute(REVOCATIONVERIFIER_ATT, inboundEndpointInfoDTO.getSslConfiguration().getRevocationVerifier(), nullNS);
            }
        }
        parentElement = fac.createOMElement(INBOUND_POLLING_ENDPOINTS_QN, (OMContainer)rootElement);
        for (Map.Entry<Object, Collection<Object>> entry : endpointPollingInfo.entrySet()) {
            String tenantDomain = (String)entry.getKey();
            listenerElem = fac.createOMElement(INBOUND_ENDPOINT_POLL_QN, (OMContainer)parentElement);
            Set lNames = (Set)entry.getValue();
            for (String strName : lNames) {
                endpointElem = fac.createOMElement(ENDPOINT_QN, (OMContainer)listenerElem);
                endpointElem.addAttribute(NAME_ATT, strName, nullNS);
                endpointElem.addAttribute(DOMAIN_ATT, tenantDomain, nullNS);
            }
        }
        return rootElement;
    }

    public static Map<Integer, List<InboundEndpointInfoDTO>> convertOMToEndpointListeningInfo(OMElement endpointInfoOM) {
        ConcurrentHashMap<Integer, List<InboundEndpointInfoDTO>> endpointInfo = new ConcurrentHashMap<Integer, List<InboundEndpointInfoDTO>>();
        Iterator rootElementsItr = endpointInfoOM.getChildrenWithName(INBOUND_LISTENING_ENDPOINTS_QN);
        if (!rootElementsItr.hasNext()) {
            return endpointInfo;
        }
        Iterator listenerElementsItr = ((OMElement)rootElementsItr.next()).getChildrenWithName(INBOUND_ENDPOINT_LISTENER_QN);
        while (listenerElementsItr.hasNext()) {
            ArrayList<InboundEndpointInfoDTO> tenantList = new ArrayList<InboundEndpointInfoDTO>();
            OMElement listenerElement = (OMElement)listenerElementsItr.next();
            int port = Integer.parseInt(listenerElement.getAttributeValue(PORT_QN));
            Iterator endpointsItr = listenerElement.getChildrenWithName(ENDPOINT_QN);
            while (endpointsItr.hasNext()) {
                OMElement endpointElement = (OMElement)endpointsItr.next();
                InboundProcessorParams params = PersistenceUtils.deserializeInboundParameters(endpointElement);
                InboundEndpointInfoDTO inboundEndpointInfoDTO = new InboundEndpointInfoDTO(endpointElement.getAttributeValue(DOMAIN_QN), endpointElement.getAttributeValue(PROTOCOL_QN), endpointElement.getAttributeValue(NAME_QN), params);
                if (endpointElement.getAttributeValue(PROTOCOL_QN).equals("https")) {
                    SSLConfiguration sslConfiguration = new SSLConfiguration(endpointElement.getAttributeValue(KEYSTORE_QN), endpointElement.getAttributeValue(TRUSTORE_QN), endpointElement.getAttributeValue(CLIENTAUTH_QN), endpointElement.getAttributeValue(HTTPSPROTOCOL_QN), endpointElement.getAttributeValue(REVOCATIONVERIFIER_QN), endpointElement.getAttributeValue(SSLPROTOCOL_QN), endpointElement.getAttributeValue(PREFERRED_CIPHERS_QN));
                    inboundEndpointInfoDTO.setSslConfiguration(sslConfiguration);
                }
                tenantList.add(inboundEndpointInfoDTO);
            }
            endpointInfo.put(port, tenantList);
        }
        return endpointInfo;
    }

    public static Map<String, Set<String>> convertOMToEndpointPollingInfo(OMElement endpointInfoOM) {
        ConcurrentHashMap<String, Set<String>> endpointInfo = new ConcurrentHashMap<String, Set<String>>();
        Iterator rootElementsItr = endpointInfoOM.getChildrenWithName(INBOUND_POLLING_ENDPOINTS_QN);
        if (!rootElementsItr.hasNext()) {
            return endpointInfo;
        }
        Iterator pollElementsItr = ((OMElement)rootElementsItr.next()).getChildrenWithName(INBOUND_ENDPOINT_POLL_QN);
        while (pollElementsItr.hasNext()) {
            ArrayList tenantList = new ArrayList();
            OMElement pollElement = (OMElement)pollElementsItr.next();
            Iterator endpointsItr = pollElement.getChildrenWithName(ENDPOINT_QN);
            while (endpointsItr.hasNext()) {
                OMElement endpointElement = (OMElement)endpointsItr.next();
                String iTenantDomain = endpointElement.getAttributeValue(DOMAIN_QN);
                String strEndpointName = endpointElement.getAttributeValue(NAME_QN);
                HashSet<String> lNames = (HashSet<String>)endpointInfo.get(iTenantDomain);
                if (lNames == null) {
                    lNames = new HashSet<String>();
                }
                lNames.add(strEndpointName);
                endpointInfo.put(iTenantDomain, lNames);
            }
        }
        return endpointInfo;
    }

    private static InboundProcessorParams deserializeInboundParameters(OMElement endpointElement) {
        InboundProcessorParams inboundParams = new InboundProcessorParams();
        inboundParams.setName(endpointElement.getAttributeValue(NAME_QN));
        inboundParams.setProtocol(endpointElement.getAttributeValue(PROTOCOL_QN));
        inboundParams.setInjectingSeq(endpointElement.getAttributeValue(INJECT_SEQ_QN));
        inboundParams.setOnErrorSeq(endpointElement.getAttributeValue(ONERROR_SEQ_QN));
        inboundParams.setClassImpl(endpointElement.getAttributeValue(CLASS_IMPL_QN));
        Properties props = new Properties();
        OMElement paramsEle = endpointElement.getFirstChildWithName(PARAMS_QN);
        if (paramsEle != null) {
            Iterator parameters = paramsEle.getChildrenWithName(PARAM_QN);
            while (parameters.hasNext()) {
                OMElement parameter = (OMElement)parameters.next();
                props.setProperty(parameter.getAttributeValue(PARAM_NAME_QN), parameter.getAttributeValue(PARAM_VALUE_QN));
            }
        }
        inboundParams.setProperties(props);
        return inboundParams;
    }

    public static int getPortOffset(Properties properties) {
        boolean usePortOffset = Boolean.valueOf(properties.getProperty(WEBSOCKET_USE_PORT_OFFSET));
        if (usePortOffset) {
            return PersistenceUtils.getPortOffset();
        }
        return 0;
    }

    public static int getPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffsetInCarbonXML = carbonConfig.getFirstProperty(PORT_OFFSET_CONFIG);
        String portOffset = System.getProperty(PORT_OFFSET_SYSTEM_VAR, portOffsetInCarbonXML);
        if (portOffset != null) {
            return Integer.parseInt(portOffset.trim());
        }
        return 0;
    }
}

