/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;

public class RenameResourceProcessor {
    private static final Log log = LogFactory.getLog(RenameResourceProcessor.class);

    public static void process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws Exception {
        String parentPath = request.getParameter("parentPath");
        String oldResourcePath = request.getParameter("oldResourcePath");
        String newName = request.getParameter("newName");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        try {
            ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
            client.renameResource(parentPath, oldResourcePath, newName);
        }
        catch (Exception e) {
            String msg = "Failed to rename resource " + oldResourcePath + " to the name " + newName + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(e);
        }
    }
}

