/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;

public class ChangeRolePermissionsProcessor {
    private static final Log log = LogFactory.getLog(ChangeRolePermissionsProcessor.class);

    public static void process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws UIException {
        String resourcePath = request.getParameter("resourcePath");
        String permissionInput = request.getParameter("permissionInput");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        try {
            ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
            client.changeRolePermissions(resourcePath, permissionInput);
        }
        catch (Exception e) {
            String msg = "Failed to change role permissions. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }
}

