/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.registry.resource.ui.processors.TempEditMediaTypeProcessor;

public class AddMediaTypeProcessor {
    static final String wsdlMediaType = "application/wsdl+xml";
    static final String policyMediaType = "application/policy+xml";
    static final String schemaMediaType = "application/x-xsd+xml";

    public static boolean process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws Exception, RegistryException {
        String resourcePath = request.getParameter("resourcePath");
        String mediaType = request.getParameter("mediaType");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        String xmlMimeType = "application/xml";
        String mimeMediatype = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType);
        ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
        client.updateMediaType(resourcePath, mimeMediatype);
        if (!resourcePath.contains("/_system/governance") && TempEditMediaTypeProcessor.getMediaTypeBeforeUpdate().equals(xmlMimeType) && AddMediaTypeProcessor.validateTheChangeInMediaType(mimeMediatype)) {
            AddMediaTypeProcessor.moveSelectedResource(resourcePath, mimeMediatype, client);
            client.delete(resourcePath);
            return true;
        }
        return false;
    }

    public static void moveSelectedResource(String resourePath, String mimeMediaType, ResourceServiceClient client) {
        String destinationPath = null;
        if (!resourePath.startsWith("/")) {
            resourePath = "/" + resourePath;
        }
        String parentPath = resourePath.substring(0, resourePath.lastIndexOf("/"));
        String oldResourcePath = resourePath;
        String resourceName = resourePath.substring(resourePath.lastIndexOf("/") + 1);
        destinationPath = mimeMediaType.equals(wsdlMediaType) ? "/_system/governance/trunk/wsdls" : (mimeMediaType.equals(policyMediaType) ? "/_system/governance/trunk/policies" : (mimeMediaType.equals(schemaMediaType) ? "/_system/governance/trunk/schemas" : oldResourcePath));
        try {
            client.copyResource(parentPath, oldResourcePath, destinationPath, resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean validateTheChangeInMediaType(String mimeMediaType) {
        if (mimeMediaType.equals(wsdlMediaType)) {
            return true;
        }
        if (mimeMediaType.equals(policyMediaType)) {
            return true;
        }
        return mimeMediaType.equals(schemaMediaType);
    }
}

