/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.clients;

import javax.activation.DataHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.common.utils.RegistryUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceCallbackHandler;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceStub;
import org.wso2.carbon.registry.resource.stub.beans.xsd.CollectionContentBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ContentBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ContentDownloadBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.MetadataBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.PermissionBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ResourceTreeEntryBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.VersionPath;
import org.wso2.carbon.registry.resource.stub.beans.xsd.VersionsBean;
import org.wso2.carbon.registry.resource.stub.common.xsd.ResourceData;
import org.wso2.carbon.registry.resource.stub.services.ArrayOfString;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ResourceServiceClient {
    private static final Log log = LogFactory.getLog(ResourceServiceClient.class);
    private HttpSession session;
    private ResourceAdminServiceStub stub;
    private String epr;
    private static final String ADDRESSING_MODULE = "addressing";
    private ResourceAdminServiceCallbackData callbackData = new ResourceAdminServiceCallbackData();
    private ResourceAdminServiceCallbackHandler callback = new ResourceAdminServiceCallbackHandler(this.callbackData){

        private ResourceAdminServiceCallbackData getData() {
            return (ResourceAdminServiceCallbackData)this.getClientData();
        }

        public void receiveResultaddTextResource(boolean result) {
            this.getData().setComplete();
        }

        public void receiveErroraddTextResource(Exception e) {
            this.getData().setException(e);
        }

        public void receiveErrorimportResource(Exception e) {
            this.getData().setException(e);
        }

        public void receiveResultimportResource(boolean result) {
            this.getData().setComplete();
        }

        public void receiveResultaddResource(boolean result) {
            this.getData().setComplete();
        }

        public void receiveErroraddResource(Exception e) {
            this.getData().setException(e);
        }
    };

    public ResourceServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ResourceServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        this.session = session;
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ResourceServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        this.session = session;
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ResourceAdminService";
        try {
            this.stub = new ResourceAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public MetadataBean getMetadata(HttpServletRequest request) throws Exception {
        String path = RegistryUtil.getPath((HttpServletRequest)request);
        if (path == null) {
            path = this.getSessionResourcePath();
            if (path == null) {
                path = "/";
            }
            request.setAttribute("path", (Object)path);
        }
        MetadataBean bean = null;
        try {
            bean = this.stub.getMetadata(path);
        }
        catch (Exception e) {
            String msg = "Failed to get resource metadata from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public MetadataBean getMetadata(String path) throws Exception {
        if (path == null) {
            path = "/";
        }
        MetadataBean bean = null;
        try {
            bean = this.stub.getMetadata(path);
        }
        catch (Exception e) {
            String msg = "Failed to get resource metadata from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public MetadataBean getMetadata(HttpServletRequest request, String root) throws Exception {
        String path = "/";
        request.setAttribute("path", (Object)path);
        if (path == null && (path = this.getSessionResourcePath()) == null) {
            path = "/";
        }
        MetadataBean bean = null;
        try {
            bean = this.stub.getMetadata(path);
        }
        catch (Exception e) {
            String msg = "Failed to get resource metadata from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public void setDescription(String path, String description) throws Exception {
        try {
            this.stub.setDescription(path, description);
        }
        catch (Exception e) {
            String msg = "Failed to set description of the resource " + path + ". Description: " + description + ". Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public CollectionContentBean getCollectionContent(String path) throws Exception {
        CollectionContentBean bean = null;
        try {
            bean = this.stub.getCollectionContent(path);
        }
        catch (Exception e) {
            String msg = "Failed to get collection content from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public CollectionContentBean getCollectionContent(HttpServletRequest request) throws Exception {
        String path = RegistryUtil.getPath((HttpServletRequest)request);
        CollectionContentBean bean = null;
        try {
            if (PaginationContext.getInstance() == null) {
                bean = this.stub.getCollectionContent(path);
            } else {
                PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
                bean = this.stub.getCollectionContent(path);
                int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
                this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
            }
        }
        catch (Exception e) {
            String msg = "Failed to get collection content from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            PaginationContext.destroy();
        }
        return bean;
    }

    public ContentBean getContent(HttpServletRequest request) throws Exception {
        String path = RegistryUtil.getPath((HttpServletRequest)request);
        ContentBean bean = null;
        try {
            bean = this.stub.getContentBean(path);
        }
        catch (Exception e) {
            String msg = "Failed to get content from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public ResourceData[] getResourceData(String[] paths) throws Exception {
        ResourceData[] resourceData;
        try {
            resourceData = this.stub.getResourceData(paths);
        }
        catch (Exception e) {
            String msg = "Failed to get resource data from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return resourceData;
    }

    public String addCollection(String parentPath, String collectionName, String mediaType, String description) throws Exception {
        try {
            parentPath = this.stub.addCollection(parentPath, collectionName, MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType), description);
        }
        catch (Exception e) {
            String msg = "Failed to add collection from the resource service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return parentPath;
    }

    public void addTextResource(String parentPath, String fileName, String mediaType, String description, String content) throws Exception {
        try {
            this.stub.addTextResource(parentPath, fileName, MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType), description, content);
        }
        catch (Exception e) {
            String msg = "Failed to add new text resource with name " + fileName + " to the parent collection " + parentPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addSymbolicLink(String parentPath, String name, String targetPath) throws Exception {
        try {
            this.stub.addSymbolicLink(parentPath, name, targetPath);
        }
        catch (Exception e) {
            String msg = "Failed to add symbolic link with name " + name + " to the parent collection " + parentPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addRemoteLink(String parentPath, String name, String instance, String targetPath) throws Exception {
        try {
            this.stub.addRemoteLink(parentPath, name, instance, targetPath);
        }
        catch (Exception e) {
            String msg = "Failed to add remote link with name " + name + " to the parent collection " + parentPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    private ArrayOfString[] buildPropertiesArray(String[][] properties) {
        if (properties == null) {
            return new ArrayOfString[0];
        }
        ArrayOfString[] props = new ArrayOfString[properties.length + 1];
        for (int i = 0; i < props.length - 1; ++i) {
            ArrayOfString arrayOfString = new ArrayOfString();
            arrayOfString.setArray(new String[]{properties[i][0], properties[i][1]});
            props[i] = arrayOfString;
        }
        ArrayOfString arrayOfString2 = new ArrayOfString();
        arrayOfString2.setArray(new String[]{"resource.source", "AdminConsole"});
        props[properties.length] = arrayOfString2;
        return props;
    }

    public void delete(String pathToDelete) throws Exception {
        try {
            this.stub.delete(pathToDelete);
        }
        catch (Exception e) {
            String msg = "Failed to delete " + pathToDelete + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void removeVersionHistory(String path, String snapshotId) throws Exception {
        try {
            this.stub.deleteVersionHistory(path, snapshotId);
        }
        catch (Exception e) {
            String msg = "Failed to delete the snapshot with the ID: " + snapshotId + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void renameResource(String parentPath, String oldResourcePath, String newResourceName) throws Exception {
        try {
            this.stub.renameResource(parentPath, oldResourcePath, newResourceName);
        }
        catch (Exception e) {
            String msg = "Failed to rename resource with name " + oldResourcePath + " to the new name " + newResourceName + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void copyResource(String parentPath, String oldResourcePath, String destinationPath, String resourceName) throws Exception {
        try {
            this.stub.copyResource(parentPath, oldResourcePath, destinationPath, resourceName);
        }
        catch (Exception e) {
            String msg = "Failed to copy resource " + oldResourcePath + " to the path " + destinationPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void moveResource(String parentPath, String oldResourcePath, String destinationPath, String resourceName) throws Exception {
        try {
            this.stub.moveResource(parentPath, oldResourcePath, destinationPath, resourceName);
        }
        catch (Exception e) {
            String msg = "Failed to move resource " + oldResourcePath + " to the path " + destinationPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public PermissionBean getPermissions(HttpServletRequest request) throws Exception {
        PermissionBean bean;
        String path = RegistryUtil.getPath((HttpServletRequest)request);
        try {
            bean = this.stub.getPermissions(path);
        }
        catch (Exception e) {
            String msg = "Failed to get permissions of the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return bean;
    }

    public void addUserPermission(String pathToAuthorize, String userToAuthorize, String actionToAuthorize, String permissionType) throws Exception {
        try {
            this.stub.addUserPermission(pathToAuthorize, userToAuthorize, actionToAuthorize, permissionType);
        }
        catch (Exception e) {
            String msg = "Failed add " + actionToAuthorize + " permission for user " + userToAuthorize + " on resource " + pathToAuthorize + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addRolePermission(String pathToAuthorize, String roleToAuthorize, String actionToAuthorize, String permissionType) throws Exception {
        try {
            this.stub.addRolePermission(pathToAuthorize, roleToAuthorize, actionToAuthorize, permissionType);
        }
        catch (Exception e) {
            String msg = "Failed add " + actionToAuthorize + " permission for role " + roleToAuthorize + " on resource " + pathToAuthorize + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void changeUserPermissions(String resourcePath, String permissionsInput) throws Exception {
        try {
            this.stub.changeUserPermissions(resourcePath, permissionsInput);
        }
        catch (Exception e) {
            String msg = "Failed to change user permissions of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void changeRolePermissions(String resourcePath, String permissionsInput) throws Exception {
        try {
            this.stub.changeRolePermissions(resourcePath, permissionsInput);
        }
        catch (Exception e) {
            String msg = "Failed to change role permissions of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String getTextContent(HttpServletRequest request) throws Exception {
        String path = RegistryUtil.getPath((HttpServletRequest)request);
        if (path != null && path.contains("..")) {
            path = FilenameUtils.normalize((String)path);
        }
        String textContent = null;
        try {
            textContent = this.stub.getTextContent(path);
            MetadataBean metadataBean = this.stub.getMetadata(path);
            String resourceVersion = metadataBean.getResourceVersion();
            request.getSession().setAttribute("resourceVersion", (Object)resourceVersion);
        }
        catch (Exception e) {
            String msg = "Failed get text content of the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return textContent;
    }

    public String getExternalURL(HttpServletRequest request) throws Exception {
        String path = (String)request.getAttribute("path");
        if (path != null && path.contains("..")) {
            path = FilenameUtils.normalize((String)path);
        }
        String url = null;
        try {
            url = this.stub.getTextContent(path);
        }
        catch (Exception e) {
            String msg = "Failed get content of the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return url;
    }

    public void updateTextContent(String resourcePath, String contentText, String updateOverride, String resourceVersion) throws Exception {
        try {
            MetadataBean metadataBean = this.stub.getMetadata(resourcePath);
            if (!CommonUtil.isLatestVersion((String)resourceVersion, (String)metadataBean.getResourceVersion()) && !updateOverride.equals("true")) {
                throw new RegistryException("Another user has already modified this resource");
            }
            this.stub.updateTextContent(resourcePath, contentText);
        }
        catch (Exception e) {
            String msg = "Failed to update text content of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation, String[][] properties) throws Exception {
        try {
            this.stub.addResource(path, MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType), description, content, symlinkLocation, this.buildPropertiesArray(properties));
        }
        catch (Exception e) {
            String msg = "Failed to add resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public ResourceTreeEntryBean getResourceTreeEntry(String resourcePath) throws Exception {
        ResourceTreeEntryBean entryBean = null;
        try {
            Options options = this.stub._getServiceClient().getOptions();
            options.setProperty("enableMTOM", (Object)"true");
            entryBean = this.stub.getResourceTreeEntry(resourcePath);
        }
        catch (Exception e) {
            String msg = "Failed to get resource tree entry for resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        if (entryBean == null) {
            throw new ResourceNotFoundException("The resource does not exist");
        }
        return entryBean;
    }

    public String getSessionResourcePath() throws Exception {
        String sessionResourcePath;
        try {
            sessionResourcePath = this.stub.getSessionResourcePath();
        }
        catch (Exception e) {
            String msg = "Failed to get the session resource path. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        return sessionResourcePath;
    }

    public void setTextContent(String sessionResourcePath) throws Exception {
        try {
            this.stub.setSessionResourcePath(sessionResourcePath);
        }
        catch (Exception e) {
            String msg = "Failed to set session resource path to " + sessionResourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void createVersion(String resourcePath) throws Exception {
        try {
            this.stub.createVersion(resourcePath);
        }
        catch (Exception e) {
            String msg = "Failed to create version of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void restoreVersion(String versionPath) throws Exception {
        try {
            this.stub.restoreVersion(versionPath);
        }
        catch (Exception e) {
            String msg = "Failed to version version of the resource " + versionPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public VersionsBean getVersionsBean(String path) throws Exception {
        VersionsBean versionsBean;
        try {
            versionsBean = this.stub.getVersionsBean(path);
        }
        catch (Exception e) {
            String msg = "Failed to get versions of the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
        if (versionsBean.getVersionPaths() == null) {
            versionsBean.setVersionPaths(new VersionPath[0]);
        }
        return versionsBean;
    }

    public String getMediatypeDefinitions() throws Exception {
        try {
            String mime = this.stub.getMediatypeDefinitions();
            return mime;
        }
        catch (Exception e) {
            String msg = "Failed to get media type definitions from the back end server. Limited set of media types will be populated. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return "txt:text/plain,jpg:iage/jpeg,gif:image/gif";
        }
    }

    public String getCollectionMediatypeDefinitions() throws Exception {
        try {
            String mime = this.stub.getCollectionMediatypeDefinitions();
            return mime;
        }
        catch (Exception e) {
            String msg = "Failed to get media type definitions from the back end server. Limited set of media types will be populated. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return "";
        }
    }

    public String getCustomUIMediatypeDefinitions() throws Exception {
        try {
            String mime = this.stub.getCustomUIMediatypeDefinitions();
            return mime;
        }
        catch (Exception e) {
            String msg = "Failed to get custom UI media type definitions from the back end server. Limited set of media types will be populated. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return "mex:application/vnd.wso2-mex+xml";
        }
    }

    public String getProperty(String path, String key) throws Exception {
        try {
            return this.stub.getProperty(path, key);
        }
        catch (Exception e) {
            String msg = "Failed to get property with key :" + key + " form the resource in path " + path + ". Error :" + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public ContentDownloadBean getContentDownloadBean(String path) throws Exception {
        ContentDownloadBean bean = this.stub.getContentDownloadBean(path);
        return bean;
    }

    public String getHumanReadableMediaType() throws Exception {
        return this.stub.getHumanReadableMediaTypes();
    }

    public void updateMediaType(String resourcePath, String mediaType) throws Exception {
        try {
            this.stub.updateMediaType(resourcePath, mediaType);
        }
        catch (Exception e) {
            String msg = "Failed update media type of  resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public ContentDownloadBean getZipWithDependencies(String path) throws Exception {
        try {
            return this.stub.getZipWithDependencies(path);
        }
        catch (Exception e) {
            String msg = "Failed to stream the zip with dependencies " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean hasAssociations(String path, String type) throws Exception {
        return this.stub.hasAssociations(path, type);
    }

    private static class ResourceAdminServiceCallbackData {
        private boolean isComplete = false;
        private Exception exception = null;

        private ResourceAdminServiceCallbackData() {
        }

        public void setComplete() {
            this.isComplete = true;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public void handleCallback() throws Exception {
            int i = 0;
            try {
                while (!this.isComplete && this.exception == null) {
                    Thread.sleep(500L);
                    if (++i <= 288000) continue;
                    throw new Exception("Response not received within 4 hours");
                }
                if (!this.isComplete) {
                    throw this.exception;
                }
            }
            finally {
                this.isComplete = false;
                this.exception = null;
            }
        }
    }
}

