/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.CommonUtil;

public abstract class UIProcessor {
    protected static final Log log = LogFactory.getLog(UIProcessor.class);

    public abstract String process(HttpServletRequest var1, HttpServletResponse var2, ServletConfig var3) throws Exception;

    protected void sendErrorContent(HttpServletResponse response, String msg) {
        CommonUtil.sendErrorContent((HttpServletResponse)response, (String)msg);
    }

    protected void sendContent(HttpServletResponse response, String msg) {
        try {
            PrintWriter out = response.getWriter();
            out.println(msg);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            String sendError = "Failed to send message. Caused by " + e.getMessage() + "\nFollowing message was not send to the UI\n" + msg;
            log.error((Object)sendError, (Throwable)e);
        }
    }

    protected void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            String msg = "Failed to redirect to the URL " + url + ". \nCaused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String url) {
        try {
            request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            String msg = "Failed to forward the request to URL " + url + ". Caused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
        }
    }

    protected void setSectionErrorMessage(HttpServletRequest request, String msg) {
        request.getSession().setAttribute("section.error.message", (Object)msg);
    }

    protected void setSuccessMessage(HttpServletRequest request, String msg) {
        request.getSession().setAttribute("success.message", (Object)msg);
    }

    protected void addErrorMessage(HttpServletRequest request, String msg) {
        CommonUtil.addErrorMessage((HttpServletRequest)request, (String)msg);
    }
}

