/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.resolver.SchemaResolverAdapter;
import org.apache.woden.resolver.URIResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMSchemaResolverAdapter
extends SchemaResolverAdapter {
    public DOMSchemaResolverAdapter(URIResolver actualResolver, XMLElement schemaElement) {
        super(actualResolver, schemaElement);
    }

    @Override
    protected InputStream resolveFragId(String fragId) {
        String id;
        Element contextEl = (Element)this.fContextElement.getSource();
        Document doc = contextEl.getOwnerDocument();
        Element schemaEl = doc.getElementById(id = fragId.substring(1));
        if (schemaEl == null) {
            return null;
        }
        String localName = schemaEl.getLocalName();
        if (!localName.equals("schema")) {
            return null;
        }
        String prefix = schemaEl.getPrefix();
        if (prefix != null) {
            String nsUri = schemaEl.getNamespaceURI();
            String schemaNSDecl = "xmlns:" + prefix;
            boolean isSchemaNSDeclared = schemaEl.hasAttribute(schemaNSDecl);
            if (!isSchemaNSDeclared) {
                schemaEl.setAttribute(schemaNSDecl, nsUri);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(oStream));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream iStream = new ByteArrayInputStream(oStream.toByteArray());
        return iStream;
    }
}

