/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.thrift.ThriftDataReceiverFactory;
import org.wso2.carbon.databridge.receiver.thrift.conf.ThriftDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.thrift.internal.ServiceHolder;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServlet;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServlet;
import org.wso2.carbon.utils.CarbonUtils;

public class ThriftServerStartupObserver
implements ServerStartupObserver {
    private static final Log log = LogFactory.getLog(ThriftServerStartupObserver.class);

    public void completingServerStartup() {
        block9: {
            try {
                ThriftDataReceiverConfiguration thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(ServiceHolder.getDataBridgeReceiverService().getInitialConfig());
                if (thriftDataReceiverConfiguration.isEnable() && ServiceHolder.getDataReceiver() == null) {
                    String hostName;
                    block8: {
                        ServiceHolder.setDataReceiver(new ThriftDataReceiverFactory().createAgentServer(thriftDataReceiverConfiguration, ServiceHolder.getDataBridgeReceiverService()));
                        String serverUrl = CarbonUtils.getServerURL((ServerConfigurationService)ServiceHolder.getServerConfiguration(), (ConfigurationContext)ServiceHolder.getConfigurationContext().getServerConfigContext());
                        hostName = thriftDataReceiverConfiguration.getReceiverHostName();
                        if (null == hostName) {
                            try {
                                hostName = new URL(serverUrl).getHost();
                            }
                            catch (MalformedURLException e) {
                                hostName = HostAddressFinder.findAddress((String)"localhost");
                                if (serverUrl.matches("local:/.*/services/")) break block8;
                                log.info((Object)("The server url :" + serverUrl + " is using local, hence hostname is assigned as '" + hostName + "'"));
                            }
                        }
                    }
                    ServiceHolder.getDataReceiver().start(hostName, thriftDataReceiverConfiguration.getWaitingTimeInMilliSeconds());
                    ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(ServiceHolder.getDataBridgeReceiverService()));
                    TCompactProtocol.Factory inProtFactory = new TCompactProtocol.Factory();
                    TCompactProtocol.Factory outProtFactory = new TCompactProtocol.Factory();
                    ServiceHolder.getHttpServiceInstance().registerServlet("/thriftReceiver", (Servlet)new ThriftEventTransmissionServlet((TProcessor)processor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), ServiceHolder.getHttpServiceInstance().createDefaultHttpContext());
                    ThriftSecureEventTransmissionService.Processor authProcessor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(ServiceHolder.getDataBridgeReceiverService()));
                    ServiceHolder.getHttpServiceInstance().registerServlet("/securedThriftReceiver", (Servlet)new ThriftSecureEventTransmissionServlet((TProcessor)authProcessor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), ServiceHolder.getHttpServiceInstance().createDefaultHttpContext());
                    break block9;
                }
                log.info((Object)" Thrift Data Receiver is disabled.");
            }
            catch (DataBridgeException e) {
                log.error((Object)"Can not create and start Agent Server ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error in starting Agent Server ", e);
            }
        }
    }

    public void completedServerStartup() {
    }
}

