/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.receiver.thrift.internal.ServiceHolder;
import org.wso2.carbon.databridge.receiver.thrift.internal.ThriftServerStartupObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="thriftdatareceiver.component", immediate=true)
public class ThriftDataReceiverDS {
    private static final Log log = LogFactory.getLog(ThriftDataReceiverDS.class);
    private static final String DISABLE_RECEIVER = "disable.receiver";

    @Activate
    protected void activate(ComponentContext context) {
        String disableReceiver = System.getProperty(DISABLE_RECEIVER);
        if (disableReceiver != null && Boolean.parseBoolean(disableReceiver)) {
            log.info((Object)"Receiver disabled.");
            return;
        }
        context.getBundleContext().registerService(ServerStartupObserver.class.getName(), (Object)new ThriftServerStartupObserver(), null);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (ServiceHolder.getDataReceiver() != null) {
            ServiceHolder.getDataReceiver().stop();
            log.info((Object)"Thrift server shutting down...");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        ServiceHolder.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        ServiceHolder.setServerConfiguration(null);
    }

    @Reference(name="configuration.context", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContext")
    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        ServiceHolder.setConfigurationContext(configurationContext);
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        ServiceHolder.setConfigurationContext(null);
    }

    @Reference(name="databridge.core", service=DataBridgeReceiverService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDatabridgeReceiverService")
    protected void setDataBridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        ServiceHolder.setDataBridgeReceiverService(dataBridgeReceiverService);
    }

    protected void unsetDatabridgeReceiverService(DataBridgeReceiverService dataBridgeReceiverService) {
        ServiceHolder.setDataBridgeReceiverService(dataBridgeReceiverService);
    }

    @Reference(name="http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        ServiceHolder.setHttpServiceInstance(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        ServiceHolder.setHttpServiceInstance(httpService);
    }
}

