/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.exception.EventConversionException;
import org.wso2.carbon.databridge.receiver.thrift.converter.IndexCounter;

public final class ThriftEventConverter
implements EventConverter {
    public Object[] toObjectArray(ThriftEventBundle thriftEventBundle, AttributeType[] attributeTypeOrder, IndexCounter indexCounter) {
        if (attributeTypeOrder != null) {
            Object[] objects = new Object[attributeTypeOrder.length];
            block8: for (int i = 0; i < attributeTypeOrder.length; ++i) {
                switch (attributeTypeOrder[i]) {
                    case INT: {
                        objects[i] = thriftEventBundle.getIntAttributeList().get(indexCounter.getIntCount());
                        indexCounter.incrementIntCount();
                        continue block8;
                    }
                    case LONG: {
                        objects[i] = thriftEventBundle.getLongAttributeList().get(indexCounter.getLongCount());
                        indexCounter.incrementLongCount();
                        continue block8;
                    }
                    case STRING: {
                        String stringValue = (String)thriftEventBundle.getStringAttributeList().get(indexCounter.getStringCount());
                        objects[i] = stringValue.equals("_null") ? null : stringValue;
                        indexCounter.incrementStringCount();
                        continue block8;
                    }
                    case DOUBLE: {
                        objects[i] = thriftEventBundle.getDoubleAttributeList().get(indexCounter.getDoubleCount());
                        indexCounter.incrementDoubleCount();
                        continue block8;
                    }
                    case FLOAT: {
                        objects[i] = Float.valueOf(((Double)thriftEventBundle.getDoubleAttributeList().get(indexCounter.getDoubleCount())).floatValue());
                        indexCounter.incrementDoubleCount();
                        continue block8;
                    }
                    case BOOL: {
                        objects[i] = thriftEventBundle.getBoolAttributeList().get(indexCounter.getBoolCount());
                        indexCounter.incrementBoolCount();
                    }
                }
            }
            return objects;
        }
        return null;
    }

    public List<Event> toEventList(Object eventBundle, StreamTypeHolder streamTypeHolder) {
        if (eventBundle instanceof ThriftEventBundle) {
            return this.createEventList((ThriftEventBundle)eventBundle, streamTypeHolder);
        }
        throw new EventConversionException("Wrong type of event received " + eventBundle.getClass());
    }

    public int getSize(Object eventBundle) {
        if (eventBundle instanceof ThriftEventBundle) {
            ThriftEventBundle thriftEventBundle = (ThriftEventBundle)eventBundle;
            int eventBundleSize = 0;
            if (thriftEventBundle.isSetArbitraryDataMapMap()) {
                Set arbitraryDataMap = thriftEventBundle.getArbitraryDataMapMap().entrySet();
                for (Map.Entry arbitraryData : arbitraryDataMap) {
                    eventBundleSize += DataBridgeCommonsUtils.getSize((Map)((Map)arbitraryData.getValue()));
                }
                eventBundleSize += arbitraryDataMap.size() * 4;
                eventBundleSize += arbitraryDataMap.size() * DataBridgeCommonsUtils.getReferenceSize() * 2;
            }
            eventBundleSize += thriftEventBundle.getBoolAttributeListSize();
            eventBundleSize += thriftEventBundle.getBoolAttributeListSize() * DataBridgeCommonsUtils.getReferenceSize();
            eventBundleSize += thriftEventBundle.getDoubleAttributeListSize() * 8;
            eventBundleSize += thriftEventBundle.getDoubleAttributeListSize() * DataBridgeCommonsUtils.getReferenceSize();
            eventBundleSize += thriftEventBundle.getIntAttributeListSize() * 4;
            eventBundleSize += thriftEventBundle.getIntAttributeListSize() * DataBridgeCommonsUtils.getReferenceSize();
            eventBundleSize += thriftEventBundle.getLongAttributeListSize() * 8;
            eventBundleSize += thriftEventBundle.getLongAttributeListSize() * DataBridgeCommonsUtils.getReferenceSize();
            for (String aStringField : thriftEventBundle.getStringAttributeList()) {
                eventBundleSize += aStringField.getBytes().length;
            }
            eventBundleSize += thriftEventBundle.getStringAttributeListSize() * DataBridgeCommonsUtils.getReferenceSize();
            eventBundleSize += 4;
            eventBundleSize += DataBridgeCommonsUtils.getSize((String)thriftEventBundle.getSessionId());
            return eventBundleSize += 7 * DataBridgeCommonsUtils.getReferenceSize();
        }
        throw new EventConversionException("Wrong type of event received " + eventBundle.getClass());
    }

    public int getNumberOfEvents(Object eventBundle) {
        if (eventBundle instanceof ThriftEventBundle) {
            return ((ThriftEventBundle)eventBundle).getEventNum();
        }
        throw new EventConversionException("Wrong type event relieved " + eventBundle.getClass());
    }

    private List<Event> createEventList(ThriftEventBundle thriftEventBundle, StreamTypeHolder streamTypeHolder) {
        IndexCounter indexCounter = new IndexCounter();
        ArrayList<Event> eventList = new ArrayList<Event>(thriftEventBundle.getEventNum());
        String streamId = null;
        try {
            for (int i = 0; i < thriftEventBundle.getEventNum(); ++i) {
                Map arbitraryData;
                Event event = new Event();
                streamId = (String)thriftEventBundle.getStringAttributeList().get(indexCounter.getStringCount());
                indexCounter.incrementStringCount();
                event.setStreamId(streamId);
                long timeStamp = (Long)thriftEventBundle.getLongAttributeList().get(indexCounter.getLongCount());
                indexCounter.incrementLongCount();
                event.setTimeStamp(timeStamp);
                AttributeType[][] attributeTypeOrder = streamTypeHolder.getDataType(streamId);
                if (attributeTypeOrder == null) {
                    PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    if (privilegedCarbonContext.getTenantDomain() == null) {
                        privilegedCarbonContext.setTenantDomain("carbon.super");
                        privilegedCarbonContext.setTenantId(-1234);
                    }
                    streamTypeHolder.reloadStreamTypeHolder();
                    attributeTypeOrder = streamTypeHolder.getDataType(streamId);
                    if (attributeTypeOrder == null) {
                        throw new EventConversionException("No StreamDefinition for streamId " + streamId + " present in cache ");
                    }
                }
                event.setMetaData(this.toObjectArray(thriftEventBundle, attributeTypeOrder[0], indexCounter));
                event.setCorrelationData(this.toObjectArray(thriftEventBundle, attributeTypeOrder[1], indexCounter));
                event.setPayloadData(this.toObjectArray(thriftEventBundle, attributeTypeOrder[2], indexCounter));
                if (thriftEventBundle.isSetArbitraryDataMapMap() && null != (arbitraryData = (Map)thriftEventBundle.getArbitraryDataMapMap().get(i))) {
                    event.setArbitraryDataMap(arbitraryData);
                }
                eventList.add(event);
            }
        }
        catch (RuntimeException re) {
            throw new EventConversionException("Error when converting " + streamId + " of event bundle with events " + thriftEventBundle.getEventNum(), (Throwable)re);
        }
        return eventList;
    }
}

