/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift.conf;

import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.conf.DataReceiver;
import org.wso2.carbon.utils.CarbonUtils;

public class ThriftDataReceiverConfiguration {
    private boolean enable = true;
    private int secureDataReceiverPort;
    private int dataReceiverPort;
    private String sslProtocols;
    private String ciphers;
    private String receiverHostName;
    private int waitingTimeInMilliSeconds;
    private int tcpMaxWorkerThreads = 2500;
    private int tcpMinWorkerThreads = -1;
    private int tcpRequestTimeout = -1;
    private int tcpStopTimeoutVal = -1;
    private int sslMaxWorkerThreads = 2500;
    private int sslMinWorkerThreads = -1;
    private int sslRequestTimeout = -1;
    private int sslStopTimeoutVal = -1;

    public ThriftDataReceiverConfiguration(int defaultSslPort, int defaultPort) {
        this.secureDataReceiverPort = defaultSslPort;
        this.dataReceiverPort = defaultPort;
    }

    public ThriftDataReceiverConfiguration(DataBridgeConfiguration dataBridgeConfiguration) {
        DataReceiver dataReceiver = dataBridgeConfiguration.getDataReceiver("Thrift");
        int portOffset = this.getPortOffset();
        this.secureDataReceiverPort = Integer.parseInt(dataReceiver.getConfiguration("sslPort", (Object)7711).toString()) + portOffset;
        this.dataReceiverPort = Integer.parseInt(dataReceiver.getConfiguration("tcpPort", (Object)7611).toString()) + portOffset;
        this.receiverHostName = dataReceiver.getConfiguration("hostName", (Object)"0.0.0.0").toString();
        this.waitingTimeInMilliSeconds = Integer.parseInt(dataReceiver.getConfiguration("waitingTimeInMilliSeconds", (Object)0).toString());
        Object sslProtocolObj = dataReceiver.getConfiguration("sslEnabledProtocols", null);
        this.sslProtocols = sslProtocolObj != null ? sslProtocolObj.toString() : null;
        Object ciphersObj = dataReceiver.getConfiguration("ciphers", null);
        this.ciphers = sslProtocolObj != null ? ciphersObj.toString() : null;
        this.tcpMaxWorkerThreads = Integer.parseInt(dataReceiver.getConfiguration("tcpMaxWorkerThreads", (Object)this.tcpMaxWorkerThreads).toString());
        this.tcpMinWorkerThreads = Integer.parseInt(dataReceiver.getConfiguration("tcpMinWorkerThreads", (Object)this.tcpMinWorkerThreads).toString());
        this.tcpRequestTimeout = Integer.parseInt(dataReceiver.getConfiguration("tcpRequestTimeout", (Object)this.tcpRequestTimeout).toString());
        this.tcpStopTimeoutVal = Integer.parseInt(dataReceiver.getConfiguration("tcpStopTimeoutVal", (Object)this.tcpStopTimeoutVal).toString());
        this.sslMaxWorkerThreads = Integer.parseInt(dataReceiver.getConfiguration("sslMaxWorkerThreads", (Object)this.sslMaxWorkerThreads).toString());
        this.sslMinWorkerThreads = Integer.parseInt(dataReceiver.getConfiguration("sslMinWorkerThreads", (Object)this.sslMinWorkerThreads).toString());
        this.sslRequestTimeout = Integer.parseInt(dataReceiver.getConfiguration("sslRequestTimeout", (Object)this.sslRequestTimeout).toString());
        this.sslStopTimeoutVal = Integer.parseInt(dataReceiver.getConfiguration("sslStopTimeoutVal", (Object)this.sslStopTimeoutVal).toString());
        this.enable = Boolean.valueOf(dataReceiver.getConfiguration("enable", (Object)this.enable).toString());
    }

    public ThriftDataReceiverConfiguration(int defaultSslPort, int defaultPort, String confHostName) {
        this.secureDataReceiverPort = defaultSslPort;
        this.dataReceiverPort = defaultPort;
        this.receiverHostName = confHostName;
    }

    public int getDataReceiverPort() {
        return this.dataReceiverPort;
    }

    public void setDataReceiverPort(int dataReceiverPort) {
        this.dataReceiverPort = dataReceiverPort;
    }

    public int getSecureDataReceiverPort() {
        return this.secureDataReceiverPort;
    }

    public void setSecureDataReceiverPort(int secureDataReceiverPort) {
        this.secureDataReceiverPort = secureDataReceiverPort;
    }

    public String getReceiverHostName() {
        return this.receiverHostName;
    }

    public void setReceiverHostName(String receiverHostName) {
        this.receiverHostName = receiverHostName;
    }

    public int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }

    public String getSslProtocols() {
        return this.sslProtocols;
    }

    public int getWaitingTimeInMilliSeconds() {
        return this.waitingTimeInMilliSeconds;
    }

    public void setSslProtocols(String sslProtocols) {
        this.sslProtocols = sslProtocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public int getTcpMaxWorkerThreads() {
        return this.tcpMaxWorkerThreads;
    }

    public void setTcpMaxWorkerThreads(int tcpMaxWorkerThreads) {
        this.tcpMaxWorkerThreads = tcpMaxWorkerThreads;
    }

    public int getTcpMinWorkerThreads() {
        return this.tcpMinWorkerThreads;
    }

    public void setTcpMinWorkerThreads(int tcpMinWorkerThreads) {
        this.tcpMinWorkerThreads = tcpMinWorkerThreads;
    }

    public int getTcpRequestTimeout() {
        return this.tcpRequestTimeout;
    }

    public void setTcpRequestTimeout(int tcpRequestTimeout) {
        this.tcpRequestTimeout = tcpRequestTimeout;
    }

    public int getTcpStopTimeoutVal() {
        return this.tcpStopTimeoutVal;
    }

    public void setTcpStopTimeoutVal(int tcpStopTimeoutVal) {
        this.tcpStopTimeoutVal = tcpStopTimeoutVal;
    }

    public int getSslMaxWorkerThreads() {
        return this.sslMaxWorkerThreads;
    }

    public void setSslMaxWorkerThreads(int sslMaxWorkerThreads) {
        this.sslMaxWorkerThreads = sslMaxWorkerThreads;
    }

    public int getSslMinWorkerThreads() {
        return this.sslMinWorkerThreads;
    }

    public void setSslMinWorkerThreads(int sslMinWorkerThreads) {
        this.sslMinWorkerThreads = sslMinWorkerThreads;
    }

    public int getSslRequestTimeout() {
        return this.sslRequestTimeout;
    }

    public void setSslRequestTimeout(int sslRequestTimeout) {
        this.sslRequestTimeout = sslRequestTimeout;
    }

    public int getSslStopTimeoutVal() {
        return this.sslStopTimeoutVal;
    }

    public void setSslStopTimeoutVal(int sslStopTimeoutVal) {
        this.sslStopTimeoutVal = sslStopTimeoutVal;
    }

    public boolean isEnable() {
        return this.enable;
    }
}

