/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.receiver.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.exception.DataBridgeException;
import org.wso2.carbon.databridge.receiver.thrift.conf.ThriftDataReceiverConfiguration;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.databridge.receiver.thrift.service.ThriftSecureEventTransmissionServiceImpl;

public class ThriftDataReceiver {
    private static final Log log = LogFactory.getLog(ThriftDataReceiver.class);
    private DataBridgeReceiverService dataBridgeReceiverService;
    private ThriftDataReceiverConfiguration thriftDataReceiverConfiguration;
    private TServer authenticationServer;
    private TServer dataReceiverServer;
    private int receiverStartupWaitingTime = 0;

    public ThriftDataReceiver(int secureReceiverPort, int receiverPort, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(secureReceiverPort, receiverPort);
    }

    public ThriftDataReceiver(int receiverPort, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = new ThriftDataReceiverConfiguration(receiverPort + 100, receiverPort);
    }

    public ThriftDataReceiver(ThriftDataReceiverConfiguration thriftDataReceiverConfiguration, DataBridgeReceiverService dataBridgeReceiverService) {
        this.dataBridgeReceiverService = dataBridgeReceiverService;
        this.thriftDataReceiverConfiguration = thriftDataReceiverConfiguration;
    }

    public void start(String hostName, int receiverStartupWaitingTime) throws DataBridgeException {
        this.receiverStartupWaitingTime = receiverStartupWaitingTime;
        this.startSecureEventTransmission(hostName, this.thriftDataReceiverConfiguration.getSecureDataReceiverPort(), this.thriftDataReceiverConfiguration.getSslProtocols(), this.thriftDataReceiverConfiguration.getCiphers(), this.dataBridgeReceiverService);
        this.startEventTransmission(hostName, this.thriftDataReceiverConfiguration.getDataReceiverPort(), this.dataBridgeReceiverService);
    }

    public void start(String hostName) throws DataBridgeException {
        this.start(hostName, 0);
    }

    private void startSecureEventTransmission(String hostName, int port, String sslProtocols, String ciphers, DataBridgeReceiverService dataBridgeReceiverService) throws DataBridgeException {
        try {
            ServerConfiguration serverConfig;
            ServerConfiguration serverConfig2;
            String keyStore = dataBridgeReceiverService.getInitialConfig().getKeyStoreLocation();
            if (keyStore == null && (keyStore = (serverConfig2 = ServerConfiguration.getInstance()).getFirstProperty("Security.KeyStore.Location")) == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
                throw new DataBridgeException("Cannot start thrift agent server, not valid Security.KeyStore.Location is null");
            }
            String keyStorePassword = dataBridgeReceiverService.getInitialConfig().getKeyStorePassword();
            if (keyStorePassword == null && (keyStorePassword = (serverConfig = ServerConfiguration.getInstance()).getFirstProperty("Security.KeyStore.Password")) == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
                throw new DataBridgeException("Cannot start thrift agent server, not valid Security.KeyStore.Password is null ");
            }
            this.startSecureEventTransmission(hostName, port, sslProtocols, ciphers, keyStore, keyStorePassword, dataBridgeReceiverService);
        }
        catch (TransportException e) {
            throw new DataBridgeException("Cannot start agent server on port " + port, (Throwable)e);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected void startSecureEventTransmission(String hostName, int port, String sslProtocols, String ciphers, String keyStore, String keyStorePassword, DataBridgeReceiverService dataBridgeReceiverService) throws TransportException, UnknownHostException {
        TServerSocket serverTransport;
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStore, keyStorePassword);
        try {
            InetAddress inetAddress = InetAddress.getByName(hostName);
            serverTransport = TSSLTransportFactory.getServerSocket((int)port, (int)30000, (InetAddress)inetAddress, (TSSLTransportFactory.TSSLTransportParameters)params);
            SSLServerSocket sslServerSocket = (SSLServerSocket)serverTransport.getServerSocket();
            if (sslProtocols != null && sslProtocols.length() != 0) {
                String[] sslProtocolsArray = sslProtocols.split(",");
                sslServerSocket.setEnabledProtocols(sslProtocolsArray);
            }
            if (ciphers != null && ciphers.length() != 0) {
                String[] ciphersArray = ciphers.split(",");
                sslServerSocket.setEnabledCipherSuites(ciphersArray);
            }
            log.info((Object)("Thrift Server IP : " + hostName));
        }
        catch (TTransportException e) {
            throw new TransportException("Thrift transport exception occurred ", (Throwable)e);
        }
        ThriftSecureEventTransmissionService.Processor processor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(dataBridgeReceiverService));
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).maxWorkerThreads(this.thriftDataReceiverConfiguration.getSslMaxWorkerThreads());
        if (this.thriftDataReceiverConfiguration.getSslMinWorkerThreads() != -1) {
            args.minWorkerThreads = this.thriftDataReceiverConfiguration.getSslMinWorkerThreads();
        }
        if (this.thriftDataReceiverConfiguration.getSslRequestTimeout() != -1) {
            args.requestTimeout = this.thriftDataReceiverConfiguration.getSslRequestTimeout();
        }
        if (this.thriftDataReceiverConfiguration.getSslStopTimeoutVal() != -1) {
            args.stopTimeoutVal = this.thriftDataReceiverConfiguration.getSslStopTimeoutVal();
        }
        this.authenticationServer = new TThreadPoolServer(args);
        if (log.isDebugEnabled()) {
            this.authenticationServer.setServerEventHandler((TServerEventHandler)new LoggingServerEventHandler());
        }
        String url = hostName + ":" + port;
        Thread thread = new Thread(new ServerThread(this.authenticationServer, this.receiverStartupWaitingTime, url));
        log.info((Object)("Thrift SSL port : " + port));
        thread.start();
    }

    protected void startEventTransmission(String hostName, int port, DataBridgeReceiverService dataBridgeReceiverService) throws DataBridgeException {
        try {
            TServerSocket serverTransport = new TServerSocket(new InetSocketAddress(hostName, port));
            ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(dataBridgeReceiverService));
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).maxWorkerThreads(this.thriftDataReceiverConfiguration.getTcpMaxWorkerThreads());
            if (this.thriftDataReceiverConfiguration.getTcpMinWorkerThreads() != -1) {
                args.minWorkerThreads = this.thriftDataReceiverConfiguration.getTcpMinWorkerThreads();
            }
            if (this.thriftDataReceiverConfiguration.getTcpRequestTimeout() != -1) {
                args.requestTimeout = this.thriftDataReceiverConfiguration.getTcpRequestTimeout();
            }
            if (this.thriftDataReceiverConfiguration.getTcpStopTimeoutVal() != -1) {
                args.stopTimeoutVal = this.thriftDataReceiverConfiguration.getTcpStopTimeoutVal();
            }
            this.dataReceiverServer = new TThreadPoolServer(args);
            String url = hostName + ":" + port;
            Thread thread = new Thread(new ServerThread(this.dataReceiverServer, this.receiverStartupWaitingTime, url));
            log.info((Object)("Thrift port : " + port));
            thread.start();
        }
        catch (TTransportException e) {
            throw new DataBridgeException("Cannot start Thrift server on port " + port + " on host " + hostName, (Throwable)e);
        }
    }

    public void stop() {
        this.authenticationServer.stop();
        this.dataReceiverServer.stop();
    }

    static class ServerThread
    implements Runnable {
        private TServer server;
        private int waitingTime;
        private String url;
        private static final Log log = LogFactory.getLog(ServerThread.class);

        ServerThread(TServer server, int waitingTime, String url) {
            this.server = server;
            this.waitingTime = waitingTime;
            this.url = url;
        }

        @Override
        public void run() {
            if (this.waitingTime > 0) {
                try {
                    Thread.sleep(this.waitingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            log.info((Object)("Thrift receiver started on " + this.url));
            this.server.serve();
        }
    }

    static class LoggingServerEventHandler
    implements TServerEventHandler {
        LoggingServerEventHandler() {
        }

        public void preServe() {
        }

        public ServerContext createContext(TProtocol input, TProtocol output) {
            log.debug((Object)("Client " + ((TSocket)input.getTransport()).getSocket().getRemoteSocketAddress().toString() + " connected to thrift authentication service."));
            return null;
        }

        public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
            log.debug((Object)("Client " + ((TSocket)input.getTransport()).getSocket().getRemoteSocketAddress().toString() + " disconnected from thrift authentication service."));
        }

        public void processContext(ServerContext serverContext, TTransport inputTransport, TTransport outputTransport) {
        }
    }
}

