/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.util;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.statistics.services.util.SystemStatistics;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.usage.agent.beans.APIManagerRequestStats;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.exception.UsageException;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class PublisherUtils {
    private static Log log = LogFactory.getLog(PublisherUtils.class);
    private static final String TRANSPORT = "https";
    private static ConfigurationContextService configurationContextService;
    private static DataPublisher dataPublisher;
    private static String streamId;
    private static final String usageEventStream = "org.wso2.carbon.usage.agent";
    private static final String usageEventStreamVersion = "1.0.0";
    private static final String reqStatEventStream = "org.wso2.carbon.service.request.stats";
    private static final String reqStatEventStreamVersion = "1.0.0";
    private static String reqStatEventStreamId;
    private static Map<Integer, String> serverUrlMap;

    public static String updateServerName(int tenantId) throws UsageException {
        String hostName;
        try {
            hostName = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new UsageException("Error getting host name for the registry usage event payload", e);
        }
        ConfigurationContextService configurationContextService = PublisherUtils.getConfigurationContextService();
        if (configurationContextService == null) {
            throw new UsageException("ConfigurationContext is null");
        }
        ConfigurationContext configurationContext = configurationContextService.getServerConfigContext();
        String carbonHttpsPort = System.getProperty("carbon.https.port");
        if (carbonHttpsPort == null) {
            carbonHttpsPort = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)configurationContext, (String)TRANSPORT));
        }
        String baseServerUrl = "https://" + hostName + ":" + carbonHttpsPort;
        String context = configurationContext.getContextRoot();
        String tenantDomain = null;
        try {
            Tenant tenant = Util.getRealmService().getTenantManager().getTenant(tenantId);
            if (tenant != null) {
                tenantDomain = tenant.getDomain();
            }
        }
        catch (UserStoreException e) {
            throw new UsageException("Failed to get tenant domain", (Exception)((Object)e));
        }
        String serverName = tenantDomain != null && !tenantDomain.equals("carbon.super") ? baseServerUrl + context + "t/" + tenantDomain : (context.equals("/") ? baseServerUrl + "" : baseServerUrl + context);
        return serverName;
    }

    public static String getServerUrl(int tenantId) {
        String serverUrl = serverUrlMap.get(tenantId);
        if (serverUrl != null) {
            return serverUrl;
        }
        if (serverUrl == null) {
            try {
                serverUrl = PublisherUtils.updateServerName(tenantId);
            }
            catch (UsageException e) {
                log.error((Object)("Could not create the server url for tenant id: " + tenantId), (Throwable)e);
            }
        }
        if (serverUrl != null && !"".equals(serverUrl)) {
            serverUrlMap.put(tenantId, serverUrl);
        }
        return serverUrl;
    }

    public static void defineUsageEventStream() throws Exception {
        PublisherUtils.createDataPublisher();
        if (dataPublisher == null) {
            return;
        }
        streamId = DataBridgeCommonsUtils.generateStreamId((String)usageEventStream, (String)"1.0.0");
        log.info((Object)("Event stream with stream ID: " + streamId + " found."));
    }

    public static void createDataPublisher() {
        ServerConfiguration serverConfig = CarbonUtils.getServerConfiguration();
        String trustStorePath = serverConfig.getFirstProperty("Security.TrustStore.Location");
        String trustStorePassword = serverConfig.getFirstProperty("Security.TrustStore.Password");
        String bamServerUrl = serverConfig.getFirstProperty("BamServerURL");
        String adminUsername = CommonUtil.getStratosConfig().getAdminUserName();
        String adminPassword = CommonUtil.getStratosConfig().getAdminPassword();
        System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        try {
            dataPublisher = new DataPublisher(bamServerUrl, adminUsername, adminPassword);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create a data publisher to " + bamServerUrl + ". Usage Agent will not function properly. " + e.getMessage()));
        }
    }

    public static void createAsynDataPublisher() {
        if (dataPublisher == null) {
            PublisherUtils.createDataPublisher();
        }
        if (dataPublisher == null) {
            log.warn((Object)"Cannot create the async data publisher because the data publisher is null");
            return;
        }
    }

    public static void publish(BandwidthUsage usage) throws UsageException {
        if (dataPublisher == null) {
            log.info((Object)"Creating data publisher for usage data publishing");
            PublisherUtils.createDataPublisher();
            if (dataPublisher == null) {
                return;
            }
        }
        if (streamId == null) {
            try {
                streamId = DataBridgeCommonsUtils.generateStreamId((String)usageEventStream, (String)"1.0.0");
            }
            catch (Exception exc) {
                log.error((Object)("Error occurred while searching for stream id. " + exc.getMessage()));
                return;
            }
        }
        try {
            Event usageEvent = new Event(streamId, System.currentTimeMillis(), new Object[]{"external"}, null, new Object[]{PublisherUtils.getServerUrl(usage.getTenantId()), Integer.toString(usage.getTenantId()), usage.getMeasurement(), usage.getValue()});
            dataPublisher.tryPublish(usageEvent);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while publishing usage event to BAM. " + e.getMessage()), (Throwable)e);
            throw new UsageException(e.getMessage(), e);
        }
    }

    public static void publish(SystemStatistics statistics, int tenantId) throws Exception {
        if (dataPublisher == null) {
            log.info((Object)"Creating data publisher for service-stats publishing");
            PublisherUtils.createDataPublisher();
            if (dataPublisher == null) {
                return;
            }
        }
        if (reqStatEventStreamId == null) {
            try {
                reqStatEventStreamId = DataBridgeCommonsUtils.generateStreamId((String)reqStatEventStream, (String)"1.0.0");
            }
            catch (Exception exc) {
                log.error((Object)("Error occurred while searching for stream id. " + exc.getMessage()));
                return;
            }
        }
        try {
            Event usageEvent = new Event(reqStatEventStreamId, System.currentTimeMillis(), new Object[]{"external"}, null, new Object[]{PublisherUtils.getServerUrl(tenantId), Integer.toString(tenantId), statistics.getCurrentInvocationRequestCount(), statistics.getCurrentInvocationResponseCount(), statistics.getCurrentInvocationFaultCount(), statistics.getCurrentInvocationResponseTime()});
            dataPublisher.publish(usageEvent);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while publishing usage event to BAM. " + e.getMessage()), (Throwable)e);
            throw new UsageException(e.getMessage(), e);
        }
    }

    public static void publish(APIManagerRequestStats statistics, int tenantId) throws Exception {
        if (dataPublisher == null) {
            log.info((Object)"Creating data publisher for usage data publishing");
            PublisherUtils.createDataPublisher();
            if (dataPublisher == null) {
                return;
            }
        }
        if (streamId == null) {
            try {
                streamId = DataBridgeCommonsUtils.generateStreamId((String)usageEventStream, (String)"1.0.0");
            }
            catch (Exception exc) {
                log.error((Object)("Error occurred while searching for stream id. " + exc.getMessage()));
                return;
            }
        }
        try {
            Event usageEvent = new Event(streamId, System.currentTimeMillis(), new Object[]{"external"}, null, new Object[]{PublisherUtils.getServerUrl(statistics.getTenantId()), Integer.toString(statistics.getTenantId()), statistics.getMeasurement(), statistics.getValue()});
            dataPublisher.publish(usageEvent);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while publishing usage event to BAM. " + e.getMessage()), (Throwable)e);
            throw new UsageException(e.getMessage(), e);
        }
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        PublisherUtils.configurationContextService = configurationContextService;
    }

    static {
        serverUrlMap = new HashMap<Integer, String>();
    }
}

