/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.listeners;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.statistics.services.util.SystemStatistics;
import org.wso2.carbon.usage.agent.listeners.StatisticsOutHandler;
import org.wso2.carbon.usage.agent.util.PublisherUtils;
import org.wso2.carbon.usage.agent.util.Util;

public class StatisticsInHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(StatisticsOutHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        AxisService axisService = messageContext.getAxisService();
        if (axisService == null || SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup()) || axisService.isClientSide()) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (Util.getSystemStatisticsUtil() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        SystemStatistics systemStatistics = Util.getSystemStatisticsUtil().getSystemStatistics(messageContext);
        int tenantId = -1;
        tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId == -1 || tenantId == -1234) {
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            PublisherUtils.publish(systemStatistics, tenantId);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            log.error((Object)("Error occurred while publishing request statistics. Full stacktrace available in debug logs. " + e.getMessage()));
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

